package com.yifu.cloud.plus.v1.job.compont;


import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDept;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysUser;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprUpmsProperties;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.HttpDaprUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @Author huyc
 * @Description   定时任务具体执行类
 * @Date 10:48 2022/6/16
 * @Param
 * @return
 **/
@Component(value = "updateUserTask")
@Slf4j
@EnableConfigurationProperties(DaprUpmsProperties.class)
public class updateUserTask {

	@Autowired
	private DaprUpmsProperties daprUpmsProperties;


	/**
	 * @Author huyc
	 * @Description
	 * @Date 15:49 2022/6/16
	 * @Param
	 * @return
	 **/
	public void updateUserByLdap() throws Exception {
		log.info("-------------更新用户-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/updateUser","", SysUser.class, SecurityConstants.FROM_IN);
		log.info("------------更新用户-定时任务结束------------");
	}

	/**
	 * @Author huyc
	 * @Description
	 * @Date 16:32 2022/6/16
	 * @Param
	 * @return
	 **/
	public void updateDeptByLdap() throws Exception {
		log.info("-------------更新部门-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/dept/inner/updateDept","", SysDept.class, SecurityConstants.FROM_IN);
		log.info("------------更新部门-定时任务结束------------");
	}

	public void everyDayPushGzBankBranck() {
		log.info("-------------每日1:30 拉取瓜子支行信息-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(), daprUpmsProperties.getAppId(),
				"/sysguazibankbranch/inner/pushBankBranck", "", Object.class,
				SecurityConstants.FROM_IN);
		log.info("-------------每日1.30 拉取瓜子支行信息-定时任务结束------------");
	}
}
