/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * 离职原因税友自动化配置表
 *
 * @author hgw
 * @date 2025-04-14 11:57:06
 */
@Data
@TableName("t_social_friend_reduce_set")
@Schema(description = "离职原因税友自动化配置表")
public class TSocialFriendReduceSet {

	/**
	 * 减少原因ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("减少原因ID")
	@Schema(description = "减少原因ID")
	private String id;
	/**
	 * 减少原因
	 */
	@ExcelAttribute(name = "减少原因", maxLength = 32)
	@Length(max = 32, message = "减少原因不能超过32个字符")
	@ExcelProperty("减少原因")
	@Schema(description = "减少原因")
	private String reduceReasonName;
	/**
	 * 中断原因（池州特殊减员映射1：减员原因
	 */
	@ExcelAttribute(name = "中断原因", maxLength = 32)
	@Length(max = 32, message = "中断原因不能超过32个字符")
	@ExcelProperty("中断原因")
	@Schema(description = "中断原因")
	private String tbyy;
	/**
	 * 劳动用工备案解除/终止原因（池州特殊减员映射2：劳动用工备案解除/终止原因
	 */
	@ExcelAttribute(name = "劳动用工备案解除/终止原因", maxLength = 32)
	@Length(max = 32, message = "劳动用工备案解除/终止原因不能超过32个字符")
	@ExcelProperty("劳动用工备案解除/终止原因")
	@Schema(description = "劳动用工备案解除/终止原因")
	private String zzyy;
	/**
	 * 备案解除二级原因
	 */
	@ExcelAttribute(name = "备案解除二级原因", maxLength = 32)
	@Length(max = 32, message = "备案解除二级原因不能超过32个字符")
	@ExcelProperty("备案解除二级原因")
	@Schema(description = "备案解除二级原因")
	private String bajcejyy;

	/**
	 * 离职原因,存的value：1,2,3之类的
	 */
	@ExcelAttribute(name = "离职原因", maxLength = 32)
	@Length(max = 32, message = "离职原因")
	@ExcelProperty("离职原因")
	@Schema(description = "离职原因")
	private String mvpKey;
	/**
	 * 类型1：社保；2：医保；3池州特殊减员映射
	 */
	@ExcelAttribute(name = "类型", maxLength = 32)
	@Length(max = 32, message = "类型")
	@ExcelProperty("类型")
	@Schema(description = "类型1：社保；2：医保；3池州特殊减员映射")
	private String mvpType;

}
