/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author fxj
 * @date 2025-10-15 14:50:53
 */
@Data
public class TSocialAlertInfoVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@Length(max = 32, message = "id 不能超过32 个字符")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空", maxLength = 32)
	@Schema(description = "id")
	@ExcelProperty("id")
	private String id;
	/**
	 * 项目编码
	 */
	@Length(max = 50, message = "项目编码 不能超过50 个字符")
	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String deptNo;
	/**
	 * 项目名称
	 */
	@Length(max = 100, message = "项目名称 不能超过100 个字符")
	@ExcelAttribute(name = "项目名称", maxLength = 100)
	@Schema(description = "项目名称")
	@ExcelProperty("项目名称")
	private String deptName;
	/**
	 * 类型：0社保1公积金
	 */
	@Length(max = 255, message = "类型：0社保1公积金 不能超过255 个字符")
	@ExcelAttribute(name = "类型：0社保1公积金", maxLength = 255)
	@Schema(description = "类型：0社保1公积金")
	@ExcelProperty("类型：0社保1公积金")
	private String type;
	/**
	 * 员工姓名
	 */
	@Length(max = 20, message = "员工姓名 不能超过20 个字符")
	@ExcelAttribute(name = "员工姓名", maxLength = 20)
	@Schema(description = "员工姓名")
	@ExcelProperty("员工姓名")
	private String empName;
	/**
	 * 员工身份证
	 */
	@Length(max = 30, message = "员工身份证 不能超过30 个字符")
	@ExcelAttribute(name = "员工身份证", maxLength = 30)
	@Schema(description = "员工身份证")
	@ExcelProperty("员工身份证")
	private String empIdcard;
	/**
	 * 失败原因
	 */
	@Length(max = 200, message = "失败原因 不能超过200 个字符")
	@ExcelAttribute(name = "失败原因", maxLength = 200)
	@Schema(description = "失败原因")
	@ExcelProperty("失败原因")
	private String reason;
	/**
	 * 接收人
	 */
	@Length(max = 36, message = "接收人 不能超过36 个字符")
	@ExcelAttribute(name = "接收人", maxLength = 36)
	@Schema(description = "接收人")
	@ExcelProperty("接收人")
	private String receiveUser;


}
