/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.ArrayList;
import java.util.List;

/**
 * 入职确认信息变更日志表
 *
 * @author hgw
 * @date 2025-04-07 15:35:05
 */
@Data
@TableName("t_employee_pre_log")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "入职确认信息变更日志表")
public class TEmployeePreLog extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 变化主体：档案信息、商险信息
	 */
	@ExcelAttribute(name = "变化主体：档案信息、商险信息", maxLength = 100)
	@Length(max = 100, message = "变化主体：档案信息、商险信息不能超过100个字符")
	@ExcelProperty("变化主体：档案信息、商险信息")
	@Schema(description = "变化主体：档案信息、商险信息")
	private String diffTitle;
	/**
	 * 入职确认信息ID——employee_registration_pre
	 */
	@ExcelAttribute(name = "入职确认信息ID——employee_registration_pre", isNotEmpty = true, errorInfo = "入职确认信息ID——employee_registration_pre不能为空", maxLength = 32)
	@NotBlank(message = "入职确认信息ID——employee_registration_pre不能为空")
	@Length(max = 32, message = "入职确认信息ID——employee_registration_pre不能超过32个字符")
	@ExcelProperty("入职确认信息ID——employee_registration_pre")
	@Schema(description = "入职确认信息ID——employee_registration_pre")
	private String preId;

	@TableField(exist = false)
	private List<TEmployeePreLogDetail> detailList = new ArrayList<>();

}
