/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TPreEmpWorkRecording;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TPreEmpWorkRecordingMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TPreEmpWorkRecordingService;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.List;
/**
 * 预入职-员工工作履历信息表
 *
 * @author hgw
 * @date 2024-06-17 11:24:01
 */
@Log4j2
@Service
public class TPreEmpWorkRecordingServiceImpl extends ServiceImpl<TPreEmpWorkRecordingMapper, TPreEmpWorkRecording> implements TPreEmpWorkRecordingService {
    /**
     * 预入职-员工工作履历信息表简单分页查询
     * @return
     */
    @Override
    public List<TPreEmpWorkRecording> getTPreEmpWorkRecordingList(String preMainId){
        return baseMapper.getTPreEmpWorkRecordingList(preMainId);
    }

	@Override
	public void deleteByMainId(String preMainId) {
		baseMapper.deleteByMainId(preMainId);
	}

}
