/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * 薪资导入、删除锁定表（锁定后不可导入删除，除非清理掉数据）
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
@TableName("t_salary_lock")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "薪资导入、删除锁定表（锁定后不可导入删除，除非清理掉数据）")
public class TSalaryLock extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("id")
	private String id;
	/**
	 * deptId
	 */
	@ExcelAttribute(name = "deptId", isNotEmpty = true, errorInfo = "deptId不能为空", maxLength = 50)
	@NotBlank(message = "deptId不能为空")
	@Length(max = 50, message = "deptId不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("deptId")
	private String deptId;
	/**
	 * deptName
	 */
	@ExcelAttribute(name = "deptName", maxLength = 50)
	@Length(max = 50, message = "deptName不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("deptName")
	private String deptName;
	/**
	 * 类型：0创建薪资的锁；1删除薪资的锁
	 */
	@ExcelAttribute(name = "类型：0创建薪资的锁；1删除薪资的锁", isNotEmpty = true, errorInfo = "类型：0创建薪资的锁；1删除薪资的锁不能为空")
	@NotBlank(message = "类型：0创建薪资的锁；1删除薪资的锁不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型：0创建薪资的锁；1删除薪资的锁")
	private Integer type;
	/**
	 * 结算月
	 */
	@ExcelAttribute(name = "结算月", maxLength = 6)
	@Length(max = 6, message = "结算月不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算月")
	private String settleMonth;
	/**
	 * 结算金额
	 */
	@ExcelAttribute(name = "结算金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算金额")
	private BigDecimal settleMoney;
	/**
	 * 工资id（有值，代表已完成导入或删除，释放了锁）
	 */
	@ExcelAttribute(name = "工资id（有值，代表已完成导入或删除，释放了锁）", maxLength = 32)
	@Length(max = 32, message = "工资id（有值，代表已完成导入或删除，释放了锁）不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资id（有值，代表已完成导入或删除，释放了锁）")
	private String salaryId;
	/**
	 * 删除标志：0未删除；1已删除（1代表已完成导入或删除，释放了锁）
	 */
	@ExcelAttribute(name = "删除标志：0未删除；1已删除（1代表已完成导入或删除，释放了锁）", isNotEmpty = true, errorInfo = "删除标志：0未删除；1已删除（1代表已完成导入或删除，释放了锁）不能为空")
	@NotBlank(message = "删除标志：0未删除；1已删除（1代表已完成导入或删除，释放了锁）不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("删除标志：0未删除；1已删除（1代表已完成导入或删除，释放了锁）")
	private Integer deleteFlag;

}
