/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsRemuneration;
import com.yifu.cloud.plus.v1.yifu.salary.service.TStatisticsRemunerationService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TStatisticsRemunerationSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;


/**
 * 本期稿酬申报表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tstatisticsremuneration")
@Tag(name = "本期稿酬申报表管理")
public class TStatisticsRemunerationController {

	private final TStatisticsRemunerationService tStatisticsRemunerationService;

	/**
	 * 简单分页查询
	 *
	 * @param page                    分页对象
	 * @param tStatisticsRemuneration 本期稿酬申报表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TStatisticsRemuneration>> getTStatisticsRemunerationPage(Page<TStatisticsRemuneration> page, TStatisticsRemunerationSearchVo tStatisticsRemuneration) {
		return new R<>(tStatisticsRemunerationService.getTStatisticsRemunerationPage(page, tStatisticsRemuneration));
	}

	/**
	 * 通过id查询本期稿酬申报表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询")
	@GetMapping("/{id}")
	public R<TStatisticsRemuneration> getById(@PathVariable("id") String id) {
		return R.ok(tStatisticsRemunerationService.getById(id));
	}

	/**
	 * 通过id删除本期稿酬申报表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除本期稿酬申报表", description = "通过id删除本期稿酬申报表：hasPermission('salary_tstatisticsremuneration_del')")
	@SysLog("通过id删除本期稿酬申报表")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('salary_tstatisticsremuneration_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		return R.ok(tStatisticsRemunerationService.removeById(id));
	}

	/**
	 * 本期稿酬申报表 批量导出
	 *
	 * @author hgw
	 * @date 2022-08-05 11:40:14
	 **/
	@Operation(description = "导出本期稿酬申报表 hasPermission('salary_tstatisticsremuneration-export')")
	@PostMapping("/export")
	@PreAuthorize("@pms.hasPermission('salary_tstatisticsremuneration-export')")
	public void export(HttpServletResponse response, @RequestBody TStatisticsRemunerationSearchVo searchVo) {
		tStatisticsRemunerationService.listExport(response, searchVo);
	}

	/**
	 * 本期稿酬申报表 批量删除
	 *
	 * @author huyc
	 * @date 2022-08-14 21:31:15
	 **/
	@Operation(description = "批量删除本期稿酬申报表 hasPermission('salary_tstatisticsremuneration_del')")
	@SysLog("批量删除本期稿酬申报表")
	@PostMapping("/batchDelete")
	@PreAuthorize("@pms.hasPermission('salary_tstatisticsbonus_del')")
	public R batchDelete(@RequestParam String declareMonth){
		return tStatisticsRemunerationService.batchDelete(declareMonth);
	}

	/**
	 * @param
	 * @Description: 生成本期稿酬
	 * @Author: huyc
	 * @Date: 2022-08-17 18:17:48
	 * @return: com.yifu.cloud.v1.common.core.util.R
	 **/
	@Inner
	@Operation(description = "生成本期稿酬")
	@PostMapping("/inner/doStatisticsRemuneration")
	public R doStatisticsRemuneration() {
		return tStatisticsRemunerationService.doStatisticsRemuneration();
	}

	/**
	 * @param
	 * @Description: 手动刷新
	 * @Author: huyc
	 * @Date: 2022-08-31 18:17:48
	 * @return: com.yifu.cloud.v1.common.core.util.R
	 **/
	@Operation(description = "手动刷新")
	@PostMapping("/refreshStatisticsRemuneration")
	public R refreshStatisticsRemuneration(@RequestParam String declareMonth) {
		return tStatisticsRemunerationService.refreshStatisticsRemuneration(declareMonth);
	}
}
