/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * 派单信息记录表
 *
 * @author huyc
 * @date 2023-05-15 15:38:05
 */
@Data
public class SocialImportHandleVo extends RowIndex implements Serializable {

	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名" )
	@Schema(description = "员工姓名" )
	@ExcelProperty("员工姓名" )
	private String empName;

	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号",isNotEmpty = true,errorInfo = "身份证不可为空")
	@Schema(description = "身份证号" )
	@ExcelProperty("身份证号" )
	private String empIdcard;

	/**
	 * 养老保险办理状态：0 成功，1失败
	 */
	@ExcelAttribute(name = "养老保险" ,isDataId = true,readConverterExp = "0=成功,1=失败")
	@Schema(description = "养老保险办理状态：0 成功，1失败" )
	@ExcelProperty("养老保险" )
	private String ylHandleStatus;

	/**
	 * 医疗保险办理状态：0 成功，1失败
	 */
	@ExcelAttribute(name = "医疗保险" ,isDataId = true,readConverterExp = "0=成功,1=失败")
	@Schema(description = "医疗保险办理状态：0 成功，1失败" )
	@ExcelProperty("医疗保险" )
	private String ybHandleStatus;

	/**
	 * 失业保险办理状态：0 成功，1失败
	 */
	@ExcelAttribute(name = "失业保险" ,isDataId = true,readConverterExp = "0=成功,1=失败")
	@Schema(description = "失业保险办理状态：0 成功，1失败" )
	@ExcelProperty("失业保险" )
	private String syHandleStatus;

	/**
	 * 工伤保险办理状态：0 成功，1失败
	 */
	@ExcelAttribute(name = "工伤保险" ,isDataId = true,readConverterExp = "0=成功,1=失败")
	@Schema(description = "工伤保险办理状态：0 成功，1失败" )
	@ExcelProperty("工伤保险" )
	private String gsHandleStatus;

	/**
	 * 生育保险办理状态：0 成功，1失败
	 */
	@ExcelAttribute(name = "生育保险" ,isDataId = true,readConverterExp = "0=成功,1=失败")
	@Schema(description = "生育保险办理状态：0 成功，1失败" )
	@ExcelProperty("生育保险" )
	private String sjHandleStatus;

	/**
	 * 大病救助办理状态：0 成功，1失败
	 */
	@ExcelAttribute(name = "大病救助" ,isDataId = true,readConverterExp = "0=成功,1=失败")
	@Schema(description = "大病救助办理状态：0 成功，1失败" )
	@ExcelProperty("大病救助" )
	private String dbHandleStatus;

	/**
	 * 办理意见
	 */
	@ExcelAttribute(name = "办理意见", maxLength = 150)
	@Schema(description = "办理意见" )
	@ExcelProperty("办理意见" )
	private String remark;

	/**
	 * 失败类型
	 */
	@ExcelAttribute(name = "失败类型",isDataId = true,isConvert = false,dataType = ExcelAttributeConstants.SOCIAL_DISPATCH_HANDLE_REASON)
	@Schema(description = "失败类型" )
	@ExcelProperty("失败类型" )
	private String reasonType;

	/**
	 * 派单类型 0 派增 1 派减
	 */
	@ExcelAttribute(name = "派单类型",isNotEmpty = true,isDataId = true,readConverterExp = "0=派增,1=派减",errorInfo = "派单类型不可为空")
	@Schema(description = "派单类型 0 派增 1 派减" )
	@ExcelProperty("派单类型" )
	private String type;

}
