/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialFreindPushAndGet;

import java.time.LocalDateTime;

/**
 * 税友推送和拉取的日志表，用于10分钟只能推拉一次
 *
 * @author hgw
 * @date 2025-03-18 15:43:40
 */
public interface TSocialFreindPushAndGetService extends IService<TSocialFreindPushAndGet> {

	/**
	 * @param type 类型：1推送；2拉取
	 * @Description: 获取当前类型最大的时间，用来判断10分钟内是否有操作过
	 * @Author: hgw
	 * @Date: 2025/3/18 15:57
	 * @return: java.time.LocalDateTime
	 **/
	LocalDateTime getMaxTimeByType(Integer type);
}
