<p align="center">
 <img src="https://img.shields.io/badge/yifu-3.4-success.svg" alt="Build Status">
 <img src="https://img.shields.io/badge/Spring%20Cloud-2021-blue.svg" alt="Coverage Status">
 <img src="https://img.shields.io/badge/Spring%20Boot-2.6-blue.svg" alt="Downloads">
</p>

## 系统说明

- 基于 Spring Cloud 2021 、Spring Boot 2.6、 OAuth2 的 RBAC **权限管理系统**
- 基于数据驱动视图的理念封装 element-ui，即使没有 vue 的使用经验也能快速上手
- 提供对常见容器化支持 Docker、Kubernetes、Rancher2 支持
- 提供 lambda 、stream api 、webflux 的生产实践

## 快速开始

### 核心依赖

| 依赖                   | 版本         |
| ---------------------- |------------|
| Spring Boot            | 2.6.7      |
| Spring Cloud Alibaba   | 2021.0.1.0 |
| Spring Security OAuth2 | 2.3.6      |
| Mybatis Plus           | 3.5.1      |
| hutool                 | 5.7.22     |

### 模块说明

```lua
yifu-ui  -- UI-URL/yifu-ui

yifu
├── yifu-auth -- 授权服务提供[3000]
└── yifu-common -- 系统公共模块
     ├── yifu-common-bom -- 全局依赖管理控制
     ├── yifu-common-core -- 公共工具类核心包
     ├── yifu-common-datasource -- 动态数据源包
     ├── yifu-common-job -- xxl-job 封装
     ├── yifu-common-log -- 日志服务
     ├── yifu-common-mybatis -- mybatis 扩展封装
     ├── yifu-common-seata -- 分布式事务
     ├── yifu-common-security -- 安全工具类
     ├── yifu-common-swagger -- 接口文档
     └── yifu-common-test -- oauth2.0 单元测试扩展封装
└── yifu-upms -- 通用用户权限管理模块
     └── yifu-upms-api -- 通用用户权限管理系统公共api模块
     └── yifu-upms-biz -- 通用用户权限管理系统业务处理模块[4000]
└── yifu-visual
     └── yifu-monitor -- 服务监控 [5001]
     ├── yifu-codegen -- 图形化代码生成 [5002]
     ├── yifu-sentinel-dashboard -- 流量高可用 [5003]
     └── yifu-xxl-job-admin -- 分布式定时任务管理台 [5004]
```

### 本地开发 运行


请务必**完全按照**文档部署运行章节 进行操作，减少踩坑弯路！！

### Docker 运行

```
# 下载并运行服务端代码
git clone GITUTL/yifu.git

cd yifu && mvn clean install && docker-compose up -d

# 下载并运行前端UI
git clone GITURL/yifu-ui.git

cd yifu-ui && npm install -g cnpm --registry=https://registry.npm.taobao.org


cnpm install && cnpm run build:docker && cd docker && docker-compose up -d


