/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 员工职业资格信息表
 *
 * @author fxj
 * @date 2022-06-18 09:39:46
 */
@Data
@TableName("t_emp_professional_qualification")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "员工职业资格信息表")
public class TEmpProfessionalQualification extends BaseEntity {

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description ="主键")
    private String id;

    /**
     * 员工主键
     */
    @Schema(description ="员工主键")
    private String empId;

    /**
     * 员工姓名
     */
    @Schema(description ="员工姓名")
    private String empName;

    /**
     * 员工编码
     */
    @Schema(description ="员工编码")
    private String empCode;

    /**
     * 身份证号
     */
    @Schema(description ="身份证号")
    private String empIdcard;

    /**
     * 资格类型
     */
    @Schema(description ="资格类型")
    private String qualificationType;

    /**
     * 资格等级
     */
    @Schema(description ="资格等级")
    private String qualificationLevel;

    /**
     * 证书编号
     */
    @Schema(description ="证书编号")
    private String certificationNo;

    /**
     * 获取方式
     */
    @Schema(description ="获取方式")
    private String obtainType;

    /**
     * 评定机构
     */
    @Schema(description ="评定机构")
    private String assessmentUnit;

    /**
     * 申报年度
     */
    @Schema(description ="申报年度")
    private String declareYear;

    /**
     * 是否最高资格0是/1否
     */
    @Schema(description ="是否最高资格0是/1否")
    private String heightIdentification;

	/**
	 * 项目ID
	 */
	@Schema(description ="项目ID")
	private String  settleDomain;

    /**
     * 0删除作废1正常
     */
	@TableLogic
    @Schema(description ="0删除作废1正常")
    private String deleteFlag;
	/**
	 * 备注
	 */
	@Schema(description ="备注")
	private String remark;

	/**
	 * @Author fxj
	 * @Description 附件ID
	 * @Date 14:53 2022/6/21
	**/
	@TableField(exist = false)
	private String attaIds;
}
