package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author fxj
 * @Date 2022/7/1
 * @Description
 * @Version 1.0
 */
@Data
public class ContractAlertExportVo implements Serializable {
	/**
	 * 员工名称
	 */
	@ExcelAttribute(name = "员工名称" )
	@Schema(description ="员工名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工名称")
	private String empName;

	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称" )
	@Schema(description ="项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String project;

	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码" )
	@Schema(description ="项目编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	private String projectNo;

	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号" )
	@Schema(description ="身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;

	/**
	 * 员工编码
	 */
	@ExcelAttribute(name = "员工编码" )
	@Schema(description ="员工编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工编码")
	private String empCode;

	/**
	 * 合同开始日期
	 */
	@ExcelAttribute(name = "合同开始日期",isDate = true )
	@Schema(description ="合同开始日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同开始日期")
	private Date contractStart;

	/**
	 * 合同截止日期
	 */
	@ExcelAttribute(name = "合同截止日期" ,isDate = true)
	@Schema(description ="合同截止日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同截止日期")
	private Date contractEnd;

	/**
	 * 档案地-省
	 */
	@ExcelAttribute(name = "档案地-省" ,isArea = true)
	@Schema(description ="档案地-省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("档案地-省")
	private String fileProvince;

	/**
	 * 档案地-市
	 */
	@ExcelAttribute(name = "档案地-市" ,isArea = true,parentField = "fileProvince")
	@Schema(description ="档案地-市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("档案地-市")
	private String fileCity;

	/**
	 * 档案地-县
	 */
	@ExcelAttribute(name = "档案地-县" ,isArea = true,parentField = "fileCity")
	@Schema(description ="档案地-县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("档案地-县")
	private String fileTown;

	/**
	 * 员工类型
	 */
	@ExcelAttribute(name = "员工类型" ,isDataId = true,dataType =  ExcelAttributeConstants.EMP_NATRUE)
	@Schema(description ="员工类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工类型")
	private String empType;

	/**
	 * 合同类型
	 */
	@ExcelAttribute(name = "合同类型", isDataId = true,dataType = ExcelAttributeConstants.EMPLOYEE_CONTRACT_TYPE)
	@Schema(description ="合同类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同类型")
	private String contractType;

	/**
	 * 合同期限
	 */
	@ExcelAttribute(name = "合同期限" )
	@Schema(description ="合同期限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同期限")
	private String contractTerm;

	/**
	 * 到期天数
	 */
	@ExcelAttribute(name = "到期天数" )
	@Schema(description ="到期天数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("到期天数")
	private Integer daysDue;

	/**
	 * 是否过期：0 未过期 1 过期
	 */
	@ExcelAttribute(name = "是否过期",readConverterExp = "0=未过期,1=过期")
	@Schema(description ="是否过期：0 未过期 1 过期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否过期")
	private String dueFlag;

	/**
	 * 过期天数
	 */
	@ExcelAttribute(name = "过期天数" )
	@Schema(description ="过期天数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("过期天数")
	private Integer daysOver;

	/**
	 * 首次提醒时间
	 */
	@ExcelAttribute(name = "首次提醒时间" )
	@Schema(description ="首次提醒时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("首次提醒时间")
	private Date firstAlertTime;

	/**
	 * 提醒人
	 */
	@ExcelAttribute(name = "提醒人" )
	@Schema(description ="提醒人")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("提醒人")
	private String alertPerson;

	/**
	 * 处理状态
	 */
	@ExcelAttribute(name = "处理状态", readConverterExp = "0=待处理,1=处理中")
	@Schema(description ="处理状态")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("处理状态")
	private String handleStatus;
}
