/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 员工合同
 *
 * @author hgw
 * @date 2022-06-29 20:45:22
 */
@Data
@ColumnWidth(10)
public class EmployeeContractExportAuditVO implements Serializable {

	private static final long serialVersionUID = 1L;
	/**
	 * @Author fxj
	 * @Description 0派增-社保派单、1派增-无社保新签、2派增-续签、3派减-作废、4派减-终止
	 * 1、增加“审核类型”，内容为：派增-社保派单、派增-无社保新签、派增-续签、派减-作废、派减-终止
	 * 2、社保派单过来的合同，审核类型统一为：派增-社保派单；
	 * 3、合同申请处申请类型为：新签（正常签订）——审核类型为：派增-无社保新签、；续签（合同未到期重新签订、离职再入职、商务合同更改）——审核类型统一为：派增-续签；
	 * 3、合同申请处申请类型为：作废——审核类型统一为：派减-作废；终止——审核类型统一为：派减-终止；
	 * @Date 14:50 2022/11/7
	**/
	@ExcelAttribute(name = "审核类型",readConverterExp = "0=派增-社保派单,1=派增-无社保新签,2=派增-续签,3=派减-作废,4=派减-终止")
	@Schema(description = "审核类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核类型")
	private String type;

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建时间")
	private String createTime;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	@ExcelAttribute(name = "员工姓名", maxLength = 32)
	@Schema(description = "员工姓名", name = "empName")
	private String empName;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	@ExcelAttribute(name = "身份证号", maxLength = 32)
	@Schema(description = "身份证号", name = "empIdcard")
	private String empIdcard;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	@ExcelAttribute(name = "客户名称", maxLength = 128)
	@Schema(description = "客户名称", name = "subjectDepart")
	private String subjectUnit;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	@ExcelAttribute(name = "项目名称", maxLength = 128)
	@Schema(description = "项目名称", name = "subjectDepart")
	private String subjectDepart;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同类型")
	@NotBlank(message = "合同类型不能为空")
	@ExcelAttribute(name = "合同类型", isNotEmpty = true, errorInfo = "合同类型不能为空", maxLength = 32, needExport = true)
	@Schema(description = "合同类型", name = "contractName")
	private String contractName;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("业务细分")
	@ExcelAttribute(name = "业务细分", maxLength = 32, needExport = true)
	@Schema(description = "业务细分", name = "contractName")
	private String contractSubName;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("签订类型")
	@ExcelAttribute(name = "签订类型", isDataId = true, dataType = ExcelAttributeConstants.EMPLOYEE_SITUATION_TYPE)
	@Schema(description = "签订类型", name = "situation")
	private String situation;

	/**
	 * 原因说明-- 委托备注
	 */
	@ExcelAttribute(name = "原因说明", maxLength = 200, needExport = true)
	@Schema(description = "原因说明", name = "reason")
	@ExcelProperty("原因说明")
	private String reason;

	/**
	 * 创建者-姓名
	 */
	@Schema(description = "创建人")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建人")
	private String createName;

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同起始日期")
	@ExcelAttribute(name = "合同起始日期", isNotEmpty = true, errorInfo = "合同起始日期不能为空")
	@Schema(description = "合同起始日期", name = "contractStart")
	private String contractStart;

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同截止时间")
	@ExcelAttribute(name = "合同截止时间", needExport = true)
	@Schema(description = "合同截止时间", name = "contractEnd")
	private String contractEnd;

	/**
	 * 签订期限employee_contract_type
	 * 0	已完成一定工作任务为期限
	 * 1	固定期限
	 * 2	无固定期限
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("签订期限")
	@ExcelAttribute(name = "签订期限", isNotEmpty = true,  isDataId = true, dataType = ExcelAttributeConstants.EMPLOYEE_CONTRACT_TYPE, needExport = true)
	@Schema(description = "签订期限", name = "contractType")
	private String contractType;

	/**
	 * 工时制（数据字典） 1标准工时 2 综合工时 3不定时工时制
	 */
	@ExcelAttribute(name = "工时制", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.WORKING_HOURS)
	@Schema(description = "工时制（数据字典） 1标准工时 2 综合工时 3不定时工时制", name = "workingHours")
	@ExcelProperty("工时制")
	private String workingHours;
	/**
	 * 合同编码
	 */
	@NotBlank(message = "合同编码不能为空")
	@Length(max = 50, message = "合同编码不能超过50个字符")
	@ExcelAttribute(name = "合同编码", maxLength = 50)
	@ExcelProperty("合同编码")
	@Schema(description = "合同编码", name = "contractNo")
	private String contractNo;
	/**
	 * 离职日期
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("离职日期")
	@ExcelAttribute(name = "离职日期")
	@Schema(description = "离职日期", name = "contractEnd")
	private String leaveDate;
	/**
	 * 终止原因
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelAttribute(name = "终止原因")
	@Schema(description = "终止原因")
	@ExcelProperty("终止原因")
	private String reduceReason;
}
