/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * @author fxj
 * @date 2023-06-13 15:42:17
 */
@Data
public class TPersonnelRosterVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@Length(max = 32, message = "id 不能超过32 个字符")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空", maxLength = 32)
	@Schema(description = "id")
	@ExcelProperty("id")
	private String id;
	/**
	 * 客户名称
	 */
	@Length(max = 50, message = "客户名称 不能超过50 个字符")
	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Schema(description = "客户名称")
	@ExcelProperty("客户名称")
	private String customerName;
	/**
	 * 项目名称
	 */
	@Length(max = 50, message = "项目名称 不能超过50 个字符")
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Schema(description = "项目名称")
	@ExcelProperty("项目名称")
	private String departName;
	/**
	 * 项目编码
	 */
	@Length(max = 50, message = "项目编码 不能超过50 个字符")
	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String departNo;
	/**
	 * 业务类型
	 */
	@Length(max = 50, message = "业务类型 不能超过50 个字符")
	@ExcelAttribute(name = "业务类型", maxLength = 50)
	@Schema(description = "业务类型")
	@ExcelProperty("业务类型")
	private String businessPrimary;
	/**
	 * 二级分类
	 */
	@Length(max = 50, message = "二级分类 不能超过50 个字符")
	@ExcelAttribute(name = "二级分类", maxLength = 50)
	@Schema(description = "二级分类")
	@ExcelProperty("二级分类")
	private String businessSeconed;
	/**
	 * 三级分类
	 */
	@Length(max = 50, message = "三级分类 不能超过50 个字符")
	@ExcelAttribute(name = "三级分类", maxLength = 50)
	@Schema(description = "三级分类")
	@ExcelProperty("三级分类")
	private String businessThird;
	/**
	 * 标签
	 */
	@Length(max = 50, message = "标签 不能超过50 个字符")
	@ExcelAttribute(name = "标签", maxLength = 50)
	@Schema(description = "标签")
	@ExcelProperty("标签")
	private String label;
	/**
	 * 条线类型
	 */
	@Length(max = 50, message = "条线类型 不能超过50 个字符")
	@ExcelAttribute(name = "条线类型", maxLength = 50)
	@Schema(description = "条线类型")
	@ExcelProperty("条线类型")
	private String businessType;
	/**
	 * BU归属
	 */
	@Length(max = 30, message = "BU归属 不能超过30 个字符")
	@ExcelAttribute(name = "BU归属", maxLength = 30)
	@Schema(description = "BU归属")
	@ExcelProperty("BU归属")
	private String buBelong;
	/**
	 * 员工类型
	 */
	@Length(max = 20, message = "员工类型 不能超过20 个字符")
	@ExcelAttribute(name = "员工类型", maxLength = 20)
	@Schema(description = "员工类型")
	@ExcelProperty("员工类型")
	private String empType;
	/**
	 * 员工姓名
	 */
	@Length(max = 20, message = "员工姓名 不能超过20 个字符")
	@ExcelAttribute(name = "员工姓名", maxLength = 20)
	@Schema(description = "员工姓名")
	@ExcelProperty("员工姓名")
	private String empName;
	/**
	 * 性别
	 */
	@Length(max = 10, message = "性别 不能超过10 个字符")
	@ExcelAttribute(name = "性别", maxLength = 10)
	@Schema(description = "性别")
	@ExcelProperty("性别")
	private String empSex;
	/**
	 * 出生日期
	 */
	@ExcelAttribute(name = "出生日期", isDate = true)
	@Schema(description = "出生日期")
	@ExcelProperty("出生日期")
	private Date empBirthDate;
	/**
	 * 年龄
	 */
	@Length(max = 3, message = "年龄 不能超过3 个字符")
	@ExcelAttribute(name = "年龄", maxLength = 3)
	@Schema(description = "年龄")
	@ExcelProperty("年龄")
	private String empAge;
	/**
	 * 身份证号
	 */
	@Length(max = 20, message = "身份证号 不能超过20 个字符")
	@ExcelAttribute(name = "身份证号", maxLength = 20)
	@Schema(description = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 银行卡号
	 */
	@Length(max = 25, message = "银行卡号 不能超过25 个字符")
	@ExcelAttribute(name = "银行卡号", maxLength = 25)
	@Schema(description = "银行卡号")
	@ExcelProperty("银行卡号")
	private String bankNo;
	/**
	 * 开户行总行
	 */
	@Length(max = 50, message = "开户行总行 不能超过50 个字符")
	@ExcelAttribute(name = "开户行总行", maxLength = 50)
	@Schema(description = "开户行总行")
	@ExcelProperty("开户行总行")
	private String bankName;
	/**
	 * 开户行-省
	 */
	@Length(max = 30, message = "开户行-省 不能超过30 个字符")
	@ExcelAttribute(name = "开户行-省", maxLength = 30)
	@Schema(description = "开户行-省")
	@ExcelProperty("开户行-省")
	private String bankProvince;
	/**
	 * 开户行-市
	 */
	@Length(max = 30, message = "开户行-市 不能超过30 个字符")
	@ExcelAttribute(name = "开户行-市", maxLength = 30)
	@Schema(description = "开户行-市")
	@ExcelProperty("开户行-市")
	private String bankCity;
	/**
	 * 开户行支行
	 */
	@Length(max = 50, message = "开户行支行 不能超过50 个字符")
	@ExcelAttribute(name = "开户行支行", maxLength = 50)
	@Schema(description = "开户行支行")
	@ExcelProperty("开户行支行")
	private String bankNameSub;
	/**
	 * 手机号码
	 */
	@Length(max = 15, message = "手机号码 不能超过15 个字符")
	@ExcelAttribute(name = "手机号码", maxLength = 15)
	@Schema(description = "手机号码")
	@ExcelProperty("手机号码")
	private String empPhone;
	/**
	 * 档案地-省
	 */
	@Length(max = 30, message = "档案地-省 不能超过30 个字符")
	@ExcelAttribute(name = "档案地-省", maxLength = 30)
	@Schema(description = "档案地-省")
	@ExcelProperty("档案地-省")
	private String empProvince;
	/**
	 * 档案地-市
	 */
	@Length(max = 30, message = "档案地-市 不能超过30 个字符")
	@ExcelAttribute(name = "档案地-市", maxLength = 30)
	@Schema(description = "档案地-市")
	@ExcelProperty("档案地-市")
	private String empCity;
	/**
	 * 档案地-县
	 */
	@Length(max = 30, message = "档案地-县 不能超过30 个字符")
	@ExcelAttribute(name = "档案地-县", maxLength = 30)
	@Schema(description = "档案地-县")
	@ExcelProperty("档案地-县")
	private String empTown;
	/**
	 * 社保缴纳地
	 */
	@Length(max = 50, message = "社保缴纳地 不能超过50 个字符")
	@ExcelAttribute(name = "社保缴纳地", maxLength = 50)
	@Schema(description = "社保缴纳地")
	@ExcelProperty("社保缴纳地")
	private String socialAddress;
	/**
	 * 合同申请编号
	 */
	@Length(max = 32, message = "合同申请编号 不能超过32 个字符")
	@ExcelAttribute(name = "合同申请编号", maxLength = 32)
	@Schema(description = "合同申请编号")
	@ExcelProperty("合同申请编号")
	private String contractApplyNo;
	/**
	 * 合同起始时间
	 */
	@Length(max = 20, message = "合同起始时间 不能超过20 个字符")
	@ExcelAttribute(name = "合同起始时间", maxLength = 20)
	@Schema(description = "合同起始时间")
	@ExcelProperty("合同起始时间")
	private String contractStart;
	/**
	 * 合同截止时间
	 */
	@Length(max = 20, message = "合同截止时间 不能超过20 个字符")
	@ExcelAttribute(name = "合同截止时间", maxLength = 20)
	@Schema(description = "合同截止时间")
	@ExcelProperty("合同截止时间")
	private String contractEnd;
	/**
	 * 合同类型
	 */
	@Length(max = 10, message = "合同类型 不能超过10 个字符")
	@ExcelAttribute(name = "合同类型", maxLength = 10)
	@Schema(description = "合同类型")
	@ExcelProperty("合同类型")
	private String contractType;
	/**
	 * 业务细分
	 */
	@Length(max = 20, message = "业务细分 不能超过20 个字符")
	@ExcelAttribute(name = "业务细分", maxLength = 20)
	@Schema(description = "业务细分")
	@ExcelProperty("业务细分")
	private String businessDetail;
	/**
	 * 签订类型
	 */
	@Length(max = 20, message = "签订类型 不能超过20 个字符")
	@ExcelAttribute(name = "签订类型", maxLength = 20)
	@Schema(description = "签订类型")
	@ExcelProperty("签订类型")
	private String signType;
	/**
	 * 签订期限
	 */
	@Length(max = 10, message = "签订期限 不能超过10 个字符")
	@ExcelAttribute(name = "签订期限", maxLength = 10)
	@Schema(description = "签订期限")
	@ExcelProperty("签订期限")
	private String signTerm;
	/**
	 * 合同甲方
	 */
	@Length(max = 50, message = "合同甲方 不能超过50 个字符")
	@ExcelAttribute(name = "合同甲方", maxLength = 50)
	@Schema(description = "合同甲方")
	@ExcelProperty("合同甲方")
	private String contractPartyA;
	/**
	 * 合同岗位
	 */
	@Length(max = 20, message = "合同岗位 不能超过20 个字符")
	@ExcelAttribute(name = "合同岗位", maxLength = 20)
	@Schema(description = "合同岗位")
	@ExcelProperty("合同岗位")
	private String contractPost;
	/**
	 * 工时制
	 */
	@Length(max = 10, message = "工时制 不能超过10 个字符")
	@ExcelAttribute(name = "工时制", maxLength = 10)
	@Schema(description = "工时制")
	@ExcelProperty("工时制")
	private String contractTaskTime;
	/**
	 * 合同编码
	 */
	@Length(max = 30, message = "合同编码 不能超过30 个字符")
	@ExcelAttribute(name = "合同编码", maxLength = 30)
	@Schema(description = "合同编码")
	@ExcelProperty("合同编码")
	private String contractCode;
	/**
	 * 合同创建人
	 */
	@Length(max = 10, message = "合同创建人 不能超过10 个字符")
	@ExcelAttribute(name = "合同创建人", maxLength = 10)
	@Schema(description = "合同创建人")
	@ExcelProperty("合同创建人")
	private String contractCreater;
	/**
	 * 合同创建时间
	 */
	@Length(max = 10, message = "合同创建时间 不能超过10 个字符")
	@ExcelAttribute(name = "合同创建时间", maxLength = 10)
	@Schema(description = "合同创建时间")
	@ExcelProperty("合同创建时间")
	private String contractCreateTime;
	/**
	 * 数据生产月
	 */
	@Length(max = 10, message = "数据生产月 不能超过10 个字符")
	@ExcelAttribute(name = "数据生产月", maxLength = 10)
	@Schema(description = "数据生产月")
	@ExcelProperty("数据生产月")
	private String dataCreateMonth;
	/**
	 * dataCreateMomth
	 */
	@Length(max = 255, message = "dataCreateMomth 不能超过255 个字符")
	@ExcelAttribute(name = "dataCreateMomth", maxLength = 255)
	@Schema(description = "dataCreateMomth")
	@ExcelProperty("dataCreateMomth")
	private String dataCreateMomth;

}
