package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.MSetttleCustomerUser;
import com.yifu.cloud.plus.v1.yifu.archives.service.MSetttleCustomerUserService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainListVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;
import java.util.Map;


/**
 * @Author fxj
 * @Description  b端用户客户关系表
 * @Date 16:24 2022/12/27
 * @Param
 * @return
**/
@RestController
@AllArgsConstructor
@RequestMapping("/msetttlecustomeruser")
@Tag(name = "b端用户客户关系表")
public class MSetttleCustomerUserController {

    private final MSetttleCustomerUserService mSetttleCustomerUserService;

    /**
     * 简单分页查询
     *
     * @param page                 分页对象
     * @param mSetttleCustomerUser b端用户客户关系表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<MSetttleCustomerUser>> getMSetttleCustomerUserPage(Page<MSetttleCustomerUser> page, MSetttleCustomerUser mSetttleCustomerUser) {
        return new R<>(mSetttleCustomerUserService.getMSetttleCustomerUserPage(page, mSetttleCustomerUser));
    }


    /**
     * 通过id查询单条记录
     *
     * @param id
     * @return R
     */
    @Operation(description = "id查询")
    @GetMapping("/{id}")
    public R<MSetttleCustomerUser> getById(@PathVariable("id") String id) {
        return new R<>(mSetttleCustomerUserService.getById(id));
    }

    /**
     * 新增记录
     *
     * @param mSetttleCustomerUser
     * @return R
     */
    @Operation(description = "新增(wxhr:msetttlecustomeruser_add)")
    @PostMapping
    @PreAuthorize("@pms.hasPermission('wxhr:msetttlecustomeruser_add')")
    public R<Boolean> save(@Valid @RequestBody MSetttleCustomerUser mSetttleCustomerUser) {
        return new R<>(mSetttleCustomerUserService.save(mSetttleCustomerUser));
    }

    /**
     * 修改记录
     *
     * @param mSetttleCustomerUser
     * @return R
     */
    @Operation(description = "修改(wxhr:msetttlecustomeruser_edit)")
    @SysLog("修改b端用户客户关系表")
    @PutMapping
    @PreAuthorize("@pms.hasPermission('wxhr:msetttlecustomeruser_edit')")
    public R<Boolean> update(@RequestBody MSetttleCustomerUser mSetttleCustomerUser) {
        return new R<>(mSetttleCustomerUserService.updateById(mSetttleCustomerUser));
    }

    /**
     * 通过id删除一条记录
     *
     * @param id
     * @return R
     */
    @Operation(description = "删除(wxhr:msetttlecustomeruser_del)")
    @SysLog("删除b端用户客户关系表")
    @DeleteMapping("/{id}")
    @PreAuthorize("@pms.hasPermission('wxhr:msetttlecustomeruser_del')")
    public R<Boolean> removeById(@PathVariable String id) {
        return new R<>(mSetttleCustomerUserService.removeById(id));
    }
    /**
     * 远程接口获取客户用户关系
     */
    @Inner
    @PostMapping("/inner/getCustomerUserMap")
    public Map<String,String> getCustomerUserMap(@RequestBody List<Integer> userIdList) {
        return mSetttleCustomerUserService.getCustomerUser(userIdList);
    }
    /**
     * 远程接口获取客户关系数
     */
    @Inner
    @GetMapping("/inner/getCustomerCount")
    public Integer getCustomerCount() {
        return mSetttleCustomerUserService.getCustomerCount();
    }

	/**
	 * @Author fxj
	 * @Description 远程接口获取用户B端权限关系
	 * @Date 10:18 2023/1/10
	**/
	@Inner
	@PostMapping("/getSettlePermissionForB")
	public TSettleDomainListVo getSettlePermissionForB(@RequestBody String userId) {
		TSettleDomainListVo vo = new TSettleDomainListVo();
		vo.setDeptIds(mSetttleCustomerUserService.getSettlePermissionForB(userId));
		return vo;
	}

}
