/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TPersonnelRoster;
import com.yifu.cloud.plus.v1.yifu.archives.service.TPersonnelRosterService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TPersonnelRosterSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 
 *
 * @author fxj
 * @date 2023-06-13 15:42:17
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tpersonnelroster" )
@Tag(name = "员工花名册")
public class TPersonnelRosterController {

    private final TPersonnelRosterService tPersonnelRosterService;

    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tPersonnelRoster 
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TPersonnelRoster>> getTPersonnelRosterPage(Page<TPersonnelRoster> page, TPersonnelRosterSearchVo tPersonnelRoster) {
        return  new R<>(tPersonnelRosterService.getTPersonnelRosterPage(page,tPersonnelRoster));
    }
    /**
     * 不分页查询
     * @param tPersonnelRoster 
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    public R<List<TPersonnelRoster>> getTPersonnelRosterNoPage(@RequestBody TPersonnelRosterSearchVo tPersonnelRoster) {
        return R.ok(tPersonnelRosterService.noPageDiy(tPersonnelRoster));
    }

    /**
     * 通过id查询
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('demo_tpersonnelroster_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tpersonnelroster_get')" )
    public R<TPersonnelRoster> getById(@PathVariable("id" ) String id) {
        return R.ok(tPersonnelRosterService.getById(id));
    }

    /**
     * 新增
     * @param tPersonnelRoster 
     * @return R
     */
    @Operation(summary = "新增", description = "新增：hasPermission('demo_tpersonnelroster_add')")
    @SysLog("新增" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('demo_tpersonnelroster_add')" )
    public R<Boolean> save(@RequestBody TPersonnelRoster tPersonnelRoster) {
        return R.ok(tPersonnelRosterService.save(tPersonnelRoster));
    }

    /**
     * 修改
     * @param tPersonnelRoster 
     * @return R
     */
    @Operation(summary = "修改", description = "修改：hasPermission('demo_tpersonnelroster_edit')")
    @SysLog("修改" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('demo_tpersonnelroster_edit')" )
    public R<Boolean> updateById(@RequestBody TPersonnelRoster tPersonnelRoster) {
        return R.ok(tPersonnelRosterService.updateById(tPersonnelRoster));
    }

    /**
     * 通过id删除
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除", description = "通过id删除：hasPermission('demo_tpersonnelroster_del')")
    @SysLog("通过id删除" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tpersonnelroster_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tPersonnelRosterService.removeById(id));
    }

    /**
     *  批量导出
     * @author fxj
     * @date 2023-06-13 15:42:17
     **/
    @Operation(description = "导出 hasPermission('demo_tpersonnelroster-export')")
    @PostMapping("/export")
    @PreAuthorize("@pms.hasPermission('demo_tpersonnelroster-export')")
    public void export(HttpServletResponse response, @RequestBody TPersonnelRosterSearchVo searchVo) {
            tPersonnelRosterService.listExport(response,searchVo);
    }
}
