/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 人员档案表
 *
 * @author hgw
 * @date 2022-06-20 09:55:06
 */
@Mapper
public interface TEmployeeInfoMapper extends BaseMapper<TEmployeeInfo> {

	IPage<TEmployeeInfo> getPage(Page<TEmployeeInfo> page, @Param("tEmployeeInfo") TEmployeeInfo tEmployeeInfo);

	long getLeavePageCount(@Param("tEmployeeInfo") TEmployeeInfo tEmployeeInfo);

	List<TEmployeeInfo> getLeavePage(@Param("tEmployeeInfo") TEmployeeInfo tEmployeeInfo, @Param("page")Long page, @Param("size")Long size);

	IPage<TEmployeeInfo> getLeaveIPage(Page<TEmployeeInfo> page,@Param("tEmployeeInfo") TEmployeeInfo tEmployeeInfo);

	List<TEmployeeInfo> getList(@Param("tEmployeeInfo") TEmployeeInfo tEmployeeInfo);

	// hgw 2022-6-22 15:32:39 根据身份证查询一批档案
	List<TEmployeeInfo> getListByIdCard(@Param("idCardList") List<String> idCardList);

	// hgw 2022-6-22 15:32:39 根据手机号查询一批档案
	List<TEmployeeInfo> getListByPhone(@Param("phoneList") List<String> phoneList);

	int updateEducationOfEmp(@Param("education") EmpEducationUpdateVO education);

	void updateExcelEmployeeInfo(@Param("list") List<TEmployeeInfo> list);

	/**
	 * 获得导出的人员档案列表
	 * hgw 2022-6-24 10:09:44
	 */
	List<EmployeeExportVO> getTEmployeeExportList(@Param("tEmployeeInfo") TEmployeeInfo tEmployeeInfo);

	/**
	 * 获得导出的离职档案列表
	 * hgw 2022-6-24 10:09:44
	 */
	List<EmployeeExportVO> getTEmployeeLeaveExportList(@Param("tEmployeeInfo") TEmployeeInfo tEmployeeInfo);

	/**
	 * @Description: 获取当日最大的编码
	 * @Author: hgw
	 * @Date: 2022/7/1 14:57
	 * @return: java.lang.String
	 **/
	String getMaxEmpCode();

	List<DispatchEmpVo> getDispatchEmpVo(@Param("checkVo")DispatchCheckVo checkVo);
	// 同 getTEmployeeExportList 方法
	int noPageCountDiy(@Param("tEmployeeInfo")EmployeeInfoSearchVo searchVo);
	// 同 getTEmployeeExportList 方法
	List<EmployeeExportVO> noPageDiy(@Param("tEmployeeInfo")EmployeeInfoSearchVo searchVo);

	List<EmployeeLeaveExportVO> noPageLeaveDiy(@Param("tEmployeeInfo")EmployeeInfoSearchVo searchV);

	int noPageCountLeaveDiy(@Param("tEmployeeInfo")EmployeeInfoSearchVo searchV);

	int updateSocialInfoById(@Param("tEmployeeInfo")TEmployeeInfo employee);

	/**
	 * @Description: 更新档案商险状态
	 * @Author: hgw
	 * @Date: 2022/11/23 17:38
	 * @return: int
	 **/
	int updateEmployeeInfoInsuranceStatus(@Param("emp") EmpIdCardAndDeptVo emp);

	/**
	 * @Description: 更新档案薪资状态
	 * @Author: hgw
	 * @Date: 2022/11/24 11:29
	 * @return: int
	 **/
	int updateEmployeeInfoSalaryStatus(@Param("emp") EmpIdCardAndDeptVo emp);

	/**
	 * @Description: 每月1号更新档案薪资状态为否薪资
	 * @Author: hgw
	 * @Date: 2022/11/24 14:51
	 * @return: int
	 **/
	int everyMonthUpdateEmployeeInfoSalaryStatus();

	/**
	 * @param
	 * @Description: 每天更新人员档案、项目档案的过期合同为2不在用
	 * @Author: hgw
	 * @Date: 2022/11/25 14:17
	 * @return: int
	 **/
	int everyDayUpdateEmployeeInfoContractStatus();

	void updateContractStatus(@Param("empId") String empId, @Param("status")int status);
}
