package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCutsomerDataPermisson;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;

import java.util.List;

/**
 * 客户数据权限表
 *
 * @author pwang
 * @date 2019-07-19 10:39:28
 */
public interface TCutsomerDataPermissonService extends IService<TCutsomerDataPermisson> {

  /**
   * 客户数据权限表简单分页查询
   * @param tCutsomerDataPermisson 客户数据权限表
   * @return
   */
  IPage<TCutsomerDataPermisson> getTCutsomerDataPermissonPage(Page<TCutsomerDataPermisson> page, TCutsomerDataPermisson tCutsomerDataPermisson);

  /**
   * @param tCutsomerDataPermisson
   * @Description: 导出获取list
   * @Author: hgw
   * @Date: 2022/10/26 17:23
   * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.entity.TCutsomerDataPermisson>
   **/
  List<TCutsomerDataPermisson> getTCutsomerDataPermissonList(TCutsomerDataPermisson tCutsomerDataPermisson);

   /**
    * 权限复制 将srcUserList里面的所有用户权限（表）赋给 beUser 所有人
    * @Author pwang
    * @Date 2020-03-20 17:50
    * @param srcUserList
    * @param beUser
    * @param user user授权人
    * @return
    **/
   R<String> insertForCopyCutsomerDataPermisson(String[] srcUserList, String[] beUser, YifuUser user);
}
