package com.yifu.cloud.plus.v1.business.entity.system;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;


/**
 * B端预警-系统消息表表
 *
 * @author hgw
 * @date 2021-08-20 17:39:51
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_bus_warning_message")
@Schema(description = "B端预警-系统消息表")
public class TBusWarningMessage extends Model<TBusWarningMessage> {
     private static final long serialVersionUID = 1L;
     /**
      *
      */
     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "主键")
     private String id;
     /**
      * 预警主表id
      */
     @NotBlank(message = "预警主表id不能为空")
     @Length(max = 32, message = "预警主表id不能超过32个字符")
     @ExcelAttribute(name = "预警主表id", isNotEmpty = true, errorInfo = "预警主表id不能为空", maxLength = 32)
     @Schema(description = "预警主表id")
     private String warningId;
     /**
      * 提醒类型：0复审；1到期；2年假未休；3假期结束日期
      */
     @ExcelAttribute(name = "提醒类型：0复审；1到期；2年假未休；3假期结束日期")
     @Schema(description = "提醒类型：0复审；1到期；2年假未休；3假期结束日期")
     private Integer remindType;
     /**
      * 内容
      */
     @Length(max = 100, message = "内容不能超过100个字符")
     @ExcelAttribute(name = "内容", maxLength = 100)
     @Schema(description = "内容")
     private String remindContent;

     /**
      * 提醒对象（角色idStr，逗号分隔）
      */
     @Length(max = 50, message = "提醒对象（角色idStr，逗号分隔）不能超过50个字符")
     @ExcelAttribute(name = "提醒对象（角色idStr，逗号分隔）", maxLength = 50)
     @Schema(description = "提醒对象（角色idStr，逗号分隔）")
     private String remindObject;

     /**
      * 备注
      */
     @Length(max = 50, message = "备注不能超过50个字符")
     @ExcelAttribute(name = "备注", maxLength = 50)
     @Schema(description = "备注")
     private String remark;

     /**
      * 创建时间
      */
     @ExcelAttribute(name = "创建时间")
     @Schema(description = "创建时间")
     private LocalDateTime createDate;

}
