package com.yifu.cloud.plus.v1.business.service.vacation;


import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.business.dto.vacation.AddVacationMonitorClearLogDTO;
import com.yifu.cloud.plus.v1.business.entity.vacation.TVacationMonitorClearLog;
import com.yifu.cloud.plus.v1.business.vo.vacation.TVacationMonitorClearLogVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;

/**
 * @description: 假期监控清零日志表 service层
 * @author: huyc
 * @date: 2023/1/13
*/
public interface TVacationMonitorClearLogService extends IService<TVacationMonitorClearLog> {

    /**
     * @description: 查询-列表: 查询当前年假所有清零记录
     * @param vacationMonitorId 年假监控id
     * @return: R<List<TVacationMonitorClearLogVO>>
	 * @author: huyc
	 * @date: 2023/1/13
     */
    R<List<TVacationMonitorClearLogVO>> getList(String vacationMonitorId);

    /**
     * @description: 清零说明: 记录年假清零说明
     * @param dto
     * @return: R<Boolean>
	 * @author: huyc
	 * @date: 2023/1/13
     */
    R<Boolean> clearNote(AddVacationMonitorClearLogDTO dto);
}
