package com.yifu.cloud.plus.v1.yifu.common.mybatis.base;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 抽象实体
 *
 * @author lengleng
 * @date 2021/8/9
 */
@Getter
@Setter
public class BaseEntity implements Serializable {


	/**
	 * 创建者-姓名
	 */
	@Schema(description = "创建人-姓名")
	@TableField(fill = FieldFill.INSERT)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建人")
	private String createName;

	/**
	 * 创建者
	 */
	@Schema(description = "创建人")
	@TableField(fill = FieldFill.INSERT)
	@ExcelIgnore
	private String createBy;

	/**
	 * 创建时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建时间")
	private LocalDateTime createTime;

	/**
	 * 更新者
	 */
	@Schema(description = "更新人")
	@TableField(fill = FieldFill.INSERT_UPDATE)
	@ExcelIgnore
	private String updateBy;

	/**
	 * 更新时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "更新时间")
	@TableField(fill = FieldFill.INSERT_UPDATE)
	@ExcelIgnore
	@JsonIgnore
	private LocalDateTime updateTime;

	/**
	 * 菜单ID 获取查询权限使用
	 */
	@TableField(exist = false)
	@ExcelIgnore
	@JsonIgnore
	private String mId;

	/**
	 * 菜单ID 获取导出权限使用
	 */
	@TableField(exist = false)
	@ExcelIgnore
	//@JsonIgnore
	private String menuInfo;

	/**
	 * 权限sql
	 */
	@TableField(exist = false)
	@ExcelIgnore
	@JsonIgnore
	private String authSql;

}
