package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhaji
 * @description 已减员查询列表参数
 * @date 2022-07-21 11:24:03
 */
@Data
@Tag(name = "已减员查询列表参数")
public class InsuranceRefundParam extends BaseEntity implements Serializable {
	private static final long serialVersionUID = -2689686777914935788L;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;


	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 保单号
	 */
	@Schema(description = "保单号")
	private String policyNo;


	/**
	 * 保单开始时间
	 */
	@Schema(description = "保单开始时间")
	private String policyStart;

	/**
	 * 保单结束时间
	 */
	@Schema(description = "保单结束时间")
	private String policyEnd;

	/**
	 * 投保办理状态 1待投保 2投保中 3已投保 4投保退回 5 已减员
	 */
	@Schema(description = "投保办理状态 1待投保 2投保中 3已投保 4投保退回 5 已减员")
	private Integer buyHandleStatus;

	/**
	 * 项目编码列表
	 */
	@Schema(description = "项目编码列表")
	private List<String> deptNoList;

	/**
	 * 派单开始时间
	 */
	@Schema(description = "派单开始时间")
	private String startDate;

	/**
	 * 派单结束时间
	 */
	@Schema(description = "派单结束时间")
	private String endDate;

	/**
	 * 是否有效 0有效 1无效
	 */
	@Schema(description = "是否有效 0有效 1无效")
	private Integer isEffect;
}
