package com.yifu.cloud.plus.v1.yifu.insurances.mapper.insurances;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainSelectVo;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceDetail;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * @author licancan
 * @description 针对表【t_insurance_detail(商险明细表)】的数据库操作Mapper
 * @date 2022-07-18 16:20:16
 */
@Mapper
public interface TInsuranceDetailMapper extends BaseMapper<TInsuranceDetail> {
	/***********************商险办理********************************/
	/**
	 * 投保分页查询
	 *
	 * @author licancan
	 * @param page
	 * @param param
	 * @return {@link IPage< InsuranceListVO>}
	 */
	IPage<InsuranceListVO> getInsuranceListPage(Page<InsuranceListVO> page, @Param("param") InsuranceListParam param);

	/**
	 * 投保不分页查询
	 *
	 * @author licancan
	 * @param param
	 * @return {@link List<InsuranceListVO>}
	 */
	List<InsuranceListVO> getInsuranceList(@Param("param") InsuranceListParam param);

	/**
	 * 投保办理分页查询
	 *
	 * @author licancan
	 * @param page
	 * @param param
	 * @return {@link IPage< InsuranceListVO>}
	 */
	IPage<InsuranceListVO> getInsuranceHandleListPage(Page<InsuranceListVO> page, @Param("param") InsuranceListParam param);

	/**
	 * 通过id查询
	 *
	 * @author licancan
	 * @param id
	 * @return {@link InsuranceDetailVO}
	 */
	InsuranceDetailVO getInsuranceDetailById(@Param("id") String id);

	/**
	 * 导出办理勾选查询结果
	 *
	 * @author licancan
	 * @param idList
	 * @return {@link List<InsuranceExportListVO>}
	 */
	List<InsuranceExportListVO> getInsuranceExportListBySelect(@Param("idList") List<String> idList);

	/**
	 * 导出办理非勾选查询结果
	 *
	 * @author licancan
	 * @param param
	 * @return {@link List< InsuranceExportListVO>}
	 */
	List<InsuranceExportListVO> getInsuranceExportList(@Param("param") InsuranceExportListParam param);

	/**
	 * 导出办理勾选查询结果
	 *
	 * @author licancan
	 * @param idList
	 * @return {@link List<InsuranceExportListVO>}
	 */
	List<InsuranceExportListOneVO> getInsuranceExportOneListBySelect(@Param("idList") List<String> idList);

	/**
	 * 导出办理非勾选查询结果
	 *
	 * @author licancan
	 * @param param
	 * @return {@link List< InsuranceExportListVO>}
	 */
	List<InsuranceExportListOneVO> getInsuranceExportOnetList(@Param("param") InsuranceExportListParam param);

	/**
	 * 批量更新保单号
	 *
	 * @author licancan
	 * @param details
	 * @return void
	 */
	void updatePolicyNoBatch(@Param("details") List<InsuranceUpdateVO> details);

	/**
	 * 批量更新发票号
	 *
	 * @author licancan
	 * @param details
	 * @return void
	 */
	void updateInvoiceNoBatch(@Param("details") List<InsuranceUpdateVO> details);

	/***********************减员办理********************************/

	/**
	 * 已投保列表分页查询
	 *
	 * @author zhaji
	 * @param page
	 * @param param
	 * @return {@link IPage< InsuredListVo>}
	 */
	IPage<InsuredListVo> getInsuredListPage(Page<InsuredListVo> page, @Param("param") InsuredParam param);

	/**
	 * 已投保列表不分页查询
	 *
	 * @author zhaji
	 * @param param
	 * @return {@link List<InsuredListVo>}
	 */
	List<InsuredListVo> getInsuredList(@Param("param") InsuredParam param);

	/**
	 * 已投保列表不分页查询统计（excel导出统计）
	 *
	 * @author licancan
	 * @param param
	 * @return {@link long}
	 */
	long getInsuredListCount(@Param("param") InsuredParam param);

	/**
	 * 已减员列表分页查询
	 *
	 * @author zhaji
	 * @param page 分页参数
	 * @param param 查询参数
	 * @return {@link IPage<InsuranceRefundListVo>}
	 */
	IPage<InsuranceRefundListVo> getInsuranceRefundPageList(Page<InsuranceRefundParam> page,  @Param("param")InsuranceRefundParam param);

	/**
	 * 已减员列表不分页查询
	 *
	 * @author zhaji
	 * @param param 查询参数
	 * @return {@link List<InsuranceRefundListVo>}
	 */
	List<InsuranceRefundListVo> getInsuranceRefundList( @Param("param") InsuranceRefundParam param);

	/**
	 * 查询退费分页列表
	 *
	 * @author zhangyun
	 * @param page 分页参数
	 * @param param 查询参数
	 * @return {@link IPage<RefundListVo>}
	 */
	IPage<RefundListVo> getInsuranceRefundMoneyPageList(Page<RefundListVo> page,  @Param("param")InsuranceRefundHandlingParam param);

	/**
	 * 查询退费不分页列表
	 *
	 * @author zhangyun
	 * @param param 查询参数
	 * @return {@link List<RefundListVo>}
	 */
	List<RefundListVo> getInsuranceRefundMoneyList(@Param("param") InsuranceRefundHandlingParam param);


	/**
	 * 减员办理列表分页查询
	 *
	 * @author zhaji
	 * @param page 分页参数
	 * @param param 查询参数
	 * @return {@link IPage<  RefundExportListVo >}
	 */
	IPage<RefundExportListVo> getInsuranceRefundHandlingPageList(Page<InsuranceRefundHandlingParam> page, @Param("param") InsuranceRefundHandlingParam param);

	/**
	 * 减员办理
	 *
	 * @author zhaji
	 * @param insuranceDetail
	 * @return {@link boolean}
	 */
	Integer updateInsuranceRefund(@Param("param") InsuranceRefundListParam insuranceDetail);

	/**
	 * 查询保单列表
	 *
	 * @author zhaji
	 * @param idList idList
	 * @return {@link List< TInsuranceDetail>}
	 */
	List<TInsuranceDetail> selectDetailListByIds(@Param("idList") String [] idList);

	/**
	 * 查询保单减员退费信息
	 *
	 * @author zhangyun
	 * @param param 查询参数
	 * @return {@link String}
	 */
	InsuranceRefundVo  selectRefundDetailId(@Param("param") RefundMoneyUpdateParam param);

	/**
	 * 根据ID导出减员办理列表
	 *
	 * @author zhaji
	 * @param idList
	 * @return {@link List< RefundExportListVo>}
	 */
	List<RefundExportListVo> getRefundExportListBySelect(@Param("idList")List<String> idList);

	/**
	 * 导出减员办理列表
	 *
	 * @author zhaji
	 * @param param
	 * @return {@link List< RefundExportListVo>}
	 */
	List<RefundExportListVo> getRefundExportList(@Param("param") RefundExportListParam param);

	/**
	 * 根据身份证查询商险信息
	 * @param idCard 身份证号
	 * @author huyc
	 * @date 2022-08-01
	 * @return
	 */
	IPage<InsuranceListByIdCardVo> getInsuranceListByIdCard(Page<TInsuranceDetail> page, @Param("idCard") String idCard, @Param("deptNo")String deptNo);

	/**
	 * 查询所有在保，未出险，未过期，未失效，未减员的保单信息
	 *
	 * @author zhaji
	 * @param empIdcardNo
	 * @return {@link List< TInsuranceDetail>}
	 */
	List<TInsuranceDetail> selectListByEmpIdcardNo(String empIdcardNo);

	/**
	 * 商险订单减员列表查询
	 *
	 * @author zhaji
	 * @param page
	 * @param param
	 * @return {@link IPage< InsuredOrderListVo>}
	 */
	IPage<InsuredOrderListVo> getOrderInsuredListPage(Page<InsuredOrderListVo> page, @Param("param")  InsuredOrderParam param);

	/**
	 * @param idSet
	 * @param dept
	 * @Description: ekp费用划转-商险
	 * @Author: hgw
	 * @Date: 2022/11/17 11:01
	 * @return: int
	 **/
	int ekpUpdateInsuranceDept(@Param("idSet") Set<String> idSet, @Param("dept") TSettleDomainSelectVo dept);

	/**
	 * @param idCardList
	 * @Description: 根据身份证列表，查找所有商险
	 * @Author: hgw
	 * @Date: 2022/11/23 15:17
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceDetail>
	 **/
	List<TInsuranceDetail> selectByIdCardList(@Param("idCardList") List<String> idCardList
			, @Param("idList") List<String> idList);

	/**
	 * @param ids
	 * @Description: 根据id查找所有商险
	 * @Author: huyc
	 * @Date: 2022/11/29 10:17
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceDetail>
	 **/
	List<InsuranceUpdateVO> selectByIds(@Param("ids") List<String> ids);

	List<TInsuranceDetail> selectPushList();

	/**
	 * @Author fxj
	 * @Description  商险提醒分页查询
	 * @Date 16:33 2023/2/20
	**/
    IPage<TBusinessInsuranceVo> getInsuranceExpireWarnVoPage(Page<TBusinessInsuranceVo> page,
															 @Param("param")InsuranceSearchVo param,
															 @Param("domains")List<String> domains);
	List<TBusinessInsuranceVo> pageDiy(@Param("param")InsuranceSearchVo searchVo,
									   @Param("domains")List<String> idList);

	List<InsuranceWarnExportVo> noPageDiy(@Param("param")InsuranceSearchVo searchVo,
										  @Param("domains")List<String> idList);

	int noPageCountDiy(@Param("param")InsuranceSearchVo searchVo, @Param("domains")List<String> idList);

	void batchexpireIgnore(@Param("idList")List<String> idList);
}
