package com.yifu.cloud.plus.v1.yifu.insurances.service.ekp;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceTypeRate;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.EkpInsuranceViewVo;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.EkpSocialViewVo;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.SettleVo;

import java.util.List;

/**
 * @author zhaji
 * @description TODO
 * @date 2022-08-26 09:25:36
 */
public interface EkpSettleService extends IService<TInsuranceTypeRate> {

	/**
	 * 新增保险公司
	 *
	 * @author zhaji
	 * @param id 新增类
	 * @return {@link R}
	 */
	SettleVo getSettle(String id);

	/**
	 * 根据结算单编号查询商险视图信息
	 *
	 */
	List<EkpInsuranceViewVo> selectViewBySettleNo(String settleNo, String payFlag);

	 /**
	 * 根据结算单编号查询社保视图信息
	 *
	 */
	List<EkpSocialViewVo> selectSocialViewBySettleNo(String settleNo,String payFlag);
	/**
	 * 根据结算单编号查询公积金视图信息
	 *
	 */
	List<EkpSocialViewVo> selectFundViewBySettleNo(String settleNo,String payFlag);
	/**
	 * 根据结算单编号查询管理费视图信息
	 *
	 */
	List<EkpInsuranceViewVo> selectIncomelViewBySettleNo(String settleNo);
	/**
	 * 根据结算单编号查询风险金视图信息
	 *
	 */
	List<EkpInsuranceViewVo> selectFIncomelViewBySettleNo(String settleNo);
	/**
	 * 根据结算单编号查询薪资视图信息
	 *
	 */
	List<EkpSocialViewVo> selectSalarylViewBySettleNo(String settleNo,String payFlag);

}
