package com.yifu.cloud.plus.v1.yifu.insurances.service.insurance;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceDetail;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceOperate;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.*;
import com.yifu.cloud.plus.v1.yifu.social.vo.ChangeDeptVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * @author licancan
 * @description 针对表【t_insurance_detail(商险明细表)】的数据库操作Service
 * @date 2022-07-18 16:20:16
 */
public interface TInsuranceDetailService extends IService<TInsuranceDetail> {

	/***********************商险办理********************************/

	/**
	 * 每日定时刷新商险到期数据
	 *
	 * @author licancan
	 * @param
	 * @return void
	 */
	void updateOverdueByTask();

	/**
	 * EKP2INSURANCES 更新结算状态
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R<String>}
	 */
	R<String> updateInsuranceSettle(UpdateInsuranceSettleParam param);

	/**
	 * 投保分页查询
	 *
	 * @author licancan
	 * @param page
	 * @param param
	 * @return {@link IPage<InsuranceListVO>}
	 */
	IPage<InsuranceListVO> getInsuranceListPage(Page<InsuranceListVO> page, InsuranceListParam param, String mId);

	/**
	 * 投保不分页查询
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R<List<InsuranceListVO>>}
	 */
	R<List<InsuranceListVO>> getInsuranceList(InsuranceListParam param,String mId);

	/**
	 * 投保办理分页查询
	 *
	 * @author licancan
	 * @param page
	 * @param param
	 * @return {@link IPage<InsuranceListVO>}
	 */
	IPage<InsuranceListVO> getInsuranceHandleListPage(Page<InsuranceListVO> page, InsuranceListParam param, String mId);

	/**
	 * 商险新增
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceAddParam>>}
	 */
	R<List<InsuranceAddParam>> addInsurance(List<InsuranceAddParam> paramList,String orderNo);

	/**
	 * 商险批增
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceBatchParam>>}
	 */
	R<List<InsuranceBatchParam>> batchInsurance(List<InsuranceBatchParam> paramList,String orderNo);
	/**
	 * 商险替换
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceReplaceParam>>}
	 */
	R<List<InsuranceReplaceParam>> replaceInsurance(List<InsuranceReplaceParam> paramList,String orderNo);

	/**
	 * 通过id删除
	 *
	 * @author licancan
	 * @param id
	 * @return {@link R<String>}
	 */
	R<String> deleteInsurance(String id);

	/**
	 * 编辑
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R<String>}
	 */
	R<String> editInsurance(InsuranceEditParam param);

	/**
	 * 通过id查询
	 *
	 * @author licancan
	 * @param id
	 * @return {@link InsuranceDetailVO}
	 */
	InsuranceDetailVO getInsuranceDetailById(String id);

	/**
	 * 通过商险id查询操作记录
	 *
	 * @author licancan
	 * @param id
	 * @return {@link List<TInsuranceOperate>}
	 */
	List<TInsuranceOperate> getInsuranceOperateList(String id);

	/**
	 * 导出办理
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R<List<InsuranceExportListVO>>}
	 */
	R<List<InsuranceExportListVO>> getInsuranceExportList(InsuranceExportListParam param, String mId);

	/**
	 * 导出办理(新)
	 *
	 * @author huyc
	 * @param param
	 * @return {@link R<List<InsuranceExportListVO>>}
	 */
	R<List<InsuranceExportListOneVO>> getInsuranceExportOneList(InsuranceExportListParam param, String mId);

	/**
	 * 投保退回
	 *
	 * @author licancan
	 * @param user
	 * @param paramList
	 * @return {@link R<List<InsuranceListVO>>}
	 */
	R<List<InsuranceListVO>> rollBackInsurance(YifuUser user, List<InsuranceHandleParam> paramList);

	/**
	 * 投保成功/退回办理导入
	 *
	 * @author licancan
	 * @param user
	 * @param param
	 * @return {@link R<List<InsuranceHandleImportParam>>}
	 */
	R<List<InsuranceHandleImportParam>> insuranceHandleImport(YifuUser user,List<InsuranceHandleImportParam> param);

	/**
	 * 办理成功
	 *
	 * @author licancan
	 * @param user
	 * @param paramList
	 * @return {@link R<List<InsuranceListVO>>}
	 */
	R<List<InsuranceListVO>> successfulInsurance(YifuUser user, List<InsuranceHandleParam> paramList);

	/**
	 * 登记保单保费
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceRegisterParam>>}
	 */
	R<List<InsuranceRegisterParam>> registeredPolicyPremium(List<InsuranceRegisterParam> paramList);

	/**
	 * 登记发票号
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R< List<InsuranceRegisterInvoiceNoParam>>}
	 */
	R<List<InsuranceRegisterInvoiceNoParam>> registeredInvoiceNo(List<InsuranceRegisterInvoiceNoParam> paramList);

	/**
	 * 已投保信息修改
	 *
	 * @author licancan
	 * @param paramList
	 * @return {@link R<List<InsuranceInsuredParam>>}
	 */
	R<List<InsuranceInsuredParam>> updateInsuranceInsured(List<InsuranceInsuredParam> paramList);

	/**
	 * 已投保信息修改
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R< String>}
	 */
	R<String> updateInsuranceInsuredById(InsuranceInsuredDetailParam param);

	/***********************减员办理********************************/

	/**
	 * 减员导入
	 *
	 * @author zhaji
	 * @param insuranceRefundCheckList 减员表
	 * @return {@link R}
	 */
	R saveInsuranceRefund(List<InsuranceRefundCheck> insuranceRefundCheckList,String orderNo);

	/**
	 * 已投保列表分页查询
	 *
	 * @author zhaji
	 * @param page 分页参数
	 * @param param 查询参数
	 * @return {@link IPage< InsuredListVo>}
	 */
	IPage<InsuredListVo> getInsuredListPage(Page<InsuredListVo> page, InsuredParam param, String mId);

	/**
	 * 已投保列表不分页查询
	 *
	 * @author zhaji
	 * @param param 查询参数
	 * @param response 相应参数
	 * @return void
	 */
	void getInsuredList(InsuredParam param, HttpServletResponse response);

	/**
	 * 已减员列表分页查询
	 *
	 * @author zhaji
	 * @param page 分页数据
	 * @param param 查询参数
	 * @return {@link IPage<  InsuranceRefundListVo >}
	 */
	R  getInsuranceRefundPageList(Page<InsuranceRefundParam> page, InsuranceRefundParam param, String mId);

	/**
	 * 已减员列表导出
	 *
	 * @author zhaji
	 * @param param 查询参数
	 * @return {@link List<InsuranceRefundListVo>}
	 */
	R getInsuranceRefundList(InsuranceRefundParam param);

	/**
	 * 减员退费分页列表
	 *
	 * @author zhangyun
	 * @param page 分页信息
	 * @param param 筛选条件
	 * @param mId 菜单Id
	 * @return {@link R}
	 */
	R  getInsuranceRefundMoneyPageList(Page<RefundListVo> page, InsuranceRefundHandlingParam param, String mId);

	/**
	 * 减员退费不分页列表
	 *
	 * @author zhangyun
	 * @param param 筛选条件
	 * @return {@link R}
	 */
	R getInsuranceRefundMoneyList(InsuranceRefundHandlingParam param);

	/**
	 * 减员办理列表分页查询
	 *
	 * @author zhaji
	 * @param page 分页数据
	 * @param param 查询参数
	 * @param mId 菜单id
	 * @return {@link IPage<RefundExportListVo>}
	 */
	IPage<RefundExportListVo> getInsuranceRefundHandlingPageList(Page<InsuranceRefundHandlingParam> page, InsuranceRefundHandlingParam param,
																 String mId);

	/**
	 * 减员办理列表不分页查询
	 *
	 * @author zhaji
	 * @param param 查询参数
	 * @return {@link List<  RefundExportListVo >}
	 */
	R<List<RefundExportListVo>> getInsuranceRefundHandlingList(RefundExportListParam param, String mId);

	/**
	 * 减员办理
	 *
	 * @author zhaji
	 * @param insuranceDetail 办理类
	 * @return {@link R}
	 */
	R updateInsuranceRefund(InsuranceRefundListParam insuranceDetail);

	/**
	 * 减员办理导入
	 *
	 * @author zhaji
	 * @param insuranceRefundImportList 减员办理导入
	 * @return {@link R}
	 */
	R insuranceRefundImport(List<InsuranceHandleImportParam> insuranceRefundImportList);


	/**
	 * 变更结算月
	 *
	 * @author zhaji
	 * @param settleMonthCheckList 变更列表
	 * @return {@link R}
	 */
	R settleMonthChange(List<SettleMonthChangeCheckParam> settleMonthCheckList);

	/**
	 * 变更所属项目
	 *
	 * @author zhaji
	 * @param deptChangeCheckList 变更列表
	 * @return {@link R}
	 */
	R deptChange(List<DeptChangeCheckParam> deptChangeCheckList);

	/**
	 * 根据保险公司名称查询保单明细
	 *
	 * @author zhaji
	 * @param companyName 保险公司名称
	 * @return {@link R}
	 */
	R selectByCompanyName(String companyName);

	/**
	 * 根据险种id查询保单明细
	 *
	 * @author zhaji
	 * @param id
	 * @return {@link R}
	 */
	R selectByTypeId(String id);

	/**
	 * 出险
	 *
	 * @author zhaji
	 * @param id
	 * @return {@link R}
	 */
	R updateIsUse(String id);

	/**
	 * 更新减员退费
	 *
	 * @author zhangyun
	 * @param paramList 减员退费参数
	 * @return {@link R}
	 */
	R updateRefundMoney(List<RefundMoneyUpdateParam> paramList);

	/**
	 * 查询项目列表
	 *
	 * @author zhaji
	 * @param
	 * @return {@link R}
	 */
	R getDeptList();

	/**
	 * 获取当前登录人的项目列表
	 *
	 * @author zhaji
	 * @param
	 * @return {@link R}
	 */
	R getDeptListByUser();

	/**
	 * EKP紧急出险
	 *
	 * @author zhaji
	 * @param empIdcardNo
	 * @return {@link R}
	 */
	R urgentUpdateIsUse(String empIdcardNo);

	/**
	 * 紧急出险
	 *
	 * @author licancan
	 * @param paramList 商险明细id集合
	 * @return {@link R}
	 */
	R urgentUpdateIsUseByIds(List<String> paramList);

	/**
	 * 根据身份证查询商险列表
	 *
	 * @author huyc
	 * @param
	 * @return {@link R}
	 */
	IPage<InsuranceListByIdCardVo> getInsuranceListByIdCard(Page<TInsuranceDetail> page, String idCard,String deptNo);

	/**
	 * 新增订单商险
	 *
	 * @author zhaji
	 * @param paramList
	 * @return {@link R< List< InsuranceReplaceParam>>}
	 */
	R<List<InsuranceAddParam>> addOrderInsurance(InsuranceListOrderParam paramList);

	/**
	 * 批增订单商险
	 *
	 * @author zhaji
	 * @param paramList
	 * @return {@link R< List< InsuranceBatchParam>>}
	 */
	R<List<InsuranceBatchParam>> batchOrderInsurance(InsuranceOrderBatchParam paramList);

	/**
	 * 替换订单商险
	 *
	 * @author zhaji
	 * @param paramList
	 * @return {@link R< List< InsuranceReplaceParam>>}
	 */
	R<List<InsuranceReplaceParam>> replaceOrderInsurance(InsuranceOrderReplaceParam paramList);

	R refundOrderInsurance(InsuranceOrderRefundParam paramList);

	/**
	 * 订单商险列表查询
	 *
	 * @author zhaji
	 * @param page
	 * @param param
	 * @return {@link IPage< InsuredOrderListVo>}
	 */
	R getOrderInsuredListPage(Page<InsuredOrderListVo> page, InsuredOrderParam param);

	SettleVo getInsuranceDetailSettleStatus(String detailId, String defaultSettleId);

	/**
	 * @param changeDeptVo
	 * @Description: ekp费用划转，商险划转项目
	 * @Author: hgw
	 * @Date: 2022/11/17 10:56
	 * @return: void
	 **/
	void ekpUpdateInsuranceDept(ChangeDeptVo changeDeptVo);

	/**
	 * @param vo
	 * @Description: 更新商险结算状态
	 * @Author: huyc
	 * @Date: 2022/12/26 17:56
	 * @return: R
	 **/
	R updateInsuranceSettleStatus(EkpStatusParamVo vo);

	/**
	 * @param vo
	 * @Description: 更新社保结算状态
	 * @Author: huyc
	 * @Date: 2022/12/26 17:56
	 * @return: R
	 **/
	R updateSocialSettleStatus(EkpStatusParamVo vo);

	/**
	 * @param vo
	 * @Description: 更新收入结算状态
	 * @Author: huyc
	 * @Date: 2022/12/26 17:56
	 * @return: R
	 **/
	R updateIncomeSettleStatus(EkpStatusParamVo vo);

	/**
	 * @param vo
	 * @Description: 更新薪资结算状态
	 * @Author: huyc
	 * @Date: 2022/12/26 17:56
	 * @return: R
	 **/
	R updateSalarySettleStatus(EkpStatusParamVo vo);

	/**
	 * @Description: 重新更新结算状态同步失败的数据
	 * @Author: huyc
	 * @Date: 2023/1/11 15:56
	 * @return:
	 **/
	void updateSettleStatus();

	IPage<TBusinessInsuranceVo> getInsuranceExpireWarnVoPage(Page<TBusinessInsuranceVo> page, InsuranceSearchVo tBusinessInsurance);

	R<Integer> getExpireInsuranceWarn();

	R<Object> batchexpireIgnore(List<String> ids);

	R<Object> expireIgnore(TBusinessInsuranceVo vo);

	R<List<ErrorMessage>> remarkBatchAdd(InputStream inputStream);

	void exportInsurancesWarn(InsuranceSearchVo vo, HttpServletResponse response, List<String> exportFields, String idstr);

	R<Object> expireRemark(TBusinessInsuranceVo vo);
}
