/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.msg.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

/**
 * @author fxj
 * @date 2023-06-01 10:41:25
 */
@Data
@TableName("msg_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "EKP 消息提醒")
public class MsgInfo extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * orderId
	 */
	@ExcelAttribute(name = "orderId", maxLength = 50)
	@Length(max = 50, message = "orderId不能超过50个字符")
	@ExcelProperty("orderId")
	@Schema(description = "orderId")
	private String orderId;
	/**
	 * 订单号
	 */
	@ExcelAttribute(name = "订单号", maxLength = 200)
	@Length(max = 200, message = "订单号不能超过200个字符")
	@ExcelProperty("订单号")
	@Schema(description = "订单号")
	private String url;
	/**
	 * 提交人
	 */
	@ExcelAttribute(name = "提交人", maxLength = 50)
	@Length(max = 50, message = "提交人不能超过50个字符")
	@ExcelProperty("提交人")
	@Schema(description = "提交人")
	private String orderNo;
	/**
	 * 0 接单 1 超时 2变更
	 */
	@ExcelAttribute(name = "0 接单 1 超时 2变更", maxLength = 1)
	@Length(max = 1, message = "0 接单 1 超时 2变更不能超过1个字符")
	@ExcelProperty("0 接单 1 超时 2变更")
	@Schema(description = "0 接单 1 超时 2变更")
	private String alertType;

	/**
	 * 0 未阅 1 已阅
	 */
	@ExcelAttribute(name = "0 未阅 1 已阅", maxLength = 1)
	@Length(max = 1, message = "0 未阅 1 已阅不能超过1个字符")
	@ExcelProperty("0 未阅 1 已阅")
	@Schema(description = "0 未阅 1 已阅")
	private String read;
	/**
	 * 提醒人
	 */
	@ExcelAttribute(name = "提醒人", maxLength = 1)
	@Length(max = 1, message = "提醒人不能超过1个字符")
	@ExcelProperty("提醒人")
	@Schema(description = "提醒人")
	private String alertUser;

}
