/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.msg.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.msg.entity.MsgInfo;
import com.yifu.cloud.plus.v1.msg.service.MsgInfoService;
import com.yifu.cloud.plus.v1.msg.vo.EkpAlertVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * 
 *
 * @author fxj
 * @date 2023-06-01 10:41:25
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/msg" )
@Tag(name = "消息生成及查询")
public class MsgInfoController {

    private final MsgInfoService msgInfoService;

    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param msgInfo 
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<MsgInfo>> getMsgInfoPage(Page<MsgInfo> page, MsgInfo msgInfo) {
        return  new R<>(msgInfoService.getMsgInfoPage(page,msgInfo));
    }

	/**
	 * @Author fxj
	 * @Description 触发消息提醒--EKP调用接口
	 * @Date 10:52 2023/6/1
	 * @Param
	 * @return
	**/
	@Operation(summary = "触发消息提醒--EKP调用接口", description = "触发消息提醒--EKP调用接口")
	@SysLog("触发消息提醒--EKP调用接口")
	@PostMapping("/createMsg")
	public R<Boolean> createMsg(EkpAlertVo vo) {
		return msgInfoService.createMsg(vo);
	}


	/**
	 * @Author fxj
	 * @Description 每29分钟刷新 超时待办提醒
	 * @Date 20:05 2023/5/30
	 * @Param
	 * @return
	 **/
	@Operation(summary = "每29分钟刷新 超时待办提醒", description = "每29分钟刷新 超时待办提醒")
	@Inner
	@PostMapping("/inner/updateOverTimeMsg")
	public void everyMonthUpdateSalaryStatus() {
		msgInfoService.updateOverTimeMsg();
	}
}
