/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.msg.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.msg.constant.MesConstants;
import com.yifu.cloud.plus.v1.msg.entity.MsgInfo;
import com.yifu.cloud.plus.v1.msg.mapper.MsgInfoMapper;
import com.yifu.cloud.plus.v1.msg.service.MsgInfoService;
import com.yifu.cloud.plus.v1.msg.vo.EkpAlertVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
/**
 * 
 *
 * @author fxj
 * @date 2023-06-01 10:41:25
 */
@Log4j2
@Service
public class MsgInfoServiceImpl extends ServiceImpl<MsgInfoMapper, MsgInfo> implements MsgInfoService {
    /**
     * 简单分页查询
     * @param msgInfo 
     * @return
     */
    @Override
    public IPage<MsgInfo> getMsgInfoPage(Page<MsgInfo> page, MsgInfo msgInfo){
        return baseMapper.getMsgInfoPage(page,msgInfo);
    }

	@Override
	public List<MsgInfo> getMsgInfo(MsgInfo msgInfo) {
		return baseMapper.getMsgInfo(msgInfo);
	}

	/**
	 * @Author fxj
	 * @Description 生成 待办 变更 提醒数据
	 * @Date 19:36 2023/5/30
	 * @Param
	 * @return
	 **/
	@Override
	public R<Boolean> createMsg(EkpAlertVo vo) {
		if (Common.isNotNull(vo)){
			if (Common.isEmpty(vo.getItem())
					|| Common.isEmpty(vo.getType())
					|| Common.isEmpty(vo.getOrderId())
					|| Common.isEmpty(vo.getAlertUser())){
				return R.failed(CommonConstants.PARAM_INFO_ERROR);
			}
			MsgInfo save =  null;
			// 项目订单处理
			if (CommonConstants.ZERO_STRING.equals(vo.getItem())){
				// 接单提醒
				if (CommonConstants.ZERO_STRING.equals(vo.getType())){
					save = baseMapper.getMsgByOrderId(vo.getOrderId());
					if (Common.isNotNull(save)){
						save.setCreateTime(LocalDateTime.now());
						save.setUrl(MesConstants.orderUrl+vo.getOrderId());
						save.setUrl(vo.getAlertUser());
						baseMapper.insert(save);
					}
				}
				// 变更提醒
				if (CommonConstants.TWO_STRING.equals(vo.getType())){
					save = baseMapper.getMsgByOrderId(vo.getOrderId());
					if (Common.isNotNull(save)){
						save.setCreateTime(LocalDateTime.now());
						save.setUrl(MesConstants.orderUrl+save.getOrderId());
						save.setAlertType(CommonConstants.TWO_STRING);
						save.setUrl(vo.getAlertUser());
						baseMapper.insert(save);
					}
				}
			}
			return R.ok();
		}else {
			return R.failed(CommonConstants.PARAM_INFO_ERROR);
		}
	}
	/**
	 * @Author fxj
	 * @Description 定时刷新待办任务
	 * @Date 20:07 2023/5/30
	 * @Param
	 * @return
	 **/
	@Override
	public void updateOverTimeMsg() {
		List<MsgInfo>  msgInfos = baseMapper.getMsgByTask();
		if (Common.isNotNull(msgInfos)){
			//1.先删除
			baseMapper.delete(Wrappers.<MsgInfo>query().lambda().eq(MsgInfo::getAlertType,CommonConstants.ONE_STRING));
			//2. 重新生成
			for (MsgInfo ms:msgInfos){
				ms.setCreateTime(LocalDateTime.now());
				ms.setUrl(MesConstants.orderUrl+ms.getOrderId());
			}
			this.saveBatch(msgInfos);
		}
	}
}
