package com.yifu.cloud.plus.v1.yifu.order.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.order.entity.TOrder;
import com.yifu.cloud.plus.v1.yifu.order.vo.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

/**
 * @author licancan
 * @description 针对表【t_order(订单表)】的数据库操作Service
 * @date 2022-08-26 17:22:41
 */
public interface TOrderService extends IService<TOrder> {

	/**
	 * 订单列表分页查询
	 *
	 * @author licancan
	 * @param page
	 * @param param
	 * @return {@link IPage<OrderListVO>}
	 */
	IPage<OrderListVO> getOrderPageList(Page<OrderListParam> page, OrderListParam param);

	/**
	 * 订单列表不分页查询
	 *
	 * @author licancan
	 * @param param
	 * @return {@link R<List<OrderListVO>>}
	 */
	R<List<OrderListVO>> getOrderList(OrderListParam param);

	/**
	 * 变更订单状态
	 *
	 * @author licancan
	 * @param id
	 * @param status
	 * @return {@link R<String>}
	 */
	R<String> handleOrder(String id, Integer status);

	/**
	 * 通过id查询详情
	 *
	 * @author licancan
	 * @param id
	 * @return {@link R<OrderDetailVO>}
	 */
	R<OrderDetailVO> getOrderDetailById(String id);

	/**
	 * 附件预览下载地址
	 *
	 * @author licancan
	 * @param id 附件表id
	 * @return {@link R}
	 */
	R getEnclosureUrl(String id);

	/**
	 * 添加回复
	 *
	 * @author licancan
	 * @param file 附件
	 * @param filePath 附件路径
	 * @param replyContent 回复内容
	 * @param orderNo 订单编号
	 * @return {@link R}
	 * @throws IOException
	 */
	R uploadReplyEnclosure(MultipartFile[] file, String filePath, String replyContent, String orderNo) throws IOException;

	/**
	 * 订单回复列表分页查询
	 *
	 * @author licancan
	 * @param page
	 * @param orderNo
	 * @return {@link IPage< OrderReplyListVO>}
	 */
	IPage<OrderReplyListVO> getOrderReplyPageList(Page<OrderReplyListVO> page, String orderNo);

	/**
	 * 接收处理ekp订单
	 *
	 * @author licancan
	 * @param vo
	 * @return {@link R}
	 * @throws IOException
	 */
	R receiveOrder(OrderAddVO vo) throws IOException;

	/**
	 * 接收处理ekp订单回复
	 *
	 * @author licancan
	 * @param vo
	 * @return {@link R}
	 * @throws IOException
	 */
	R receiveOrderReply(OrderReplyAddVO vo) throws IOException;

	/**
	 * 订单作废
	 *
	 * @author licancan
	 * @param id
	 * @return {@link R}
	 */
	R invalidOrder(String id);
}
