/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 报账详情合计金额vo
 *
 * @author hgw
 * @date 2023-2-23 15:22:33
 */
@Data
@Schema(description = "报账详情合计金额vo")
@HeadFontStyle(fontHeightInPoints = 11)
public class TSalaryAccountSumVo {

	@ExcelProperty("应发合计")
	private BigDecimal relaySalary;
	@ExcelProperty("实发合计")
	private BigDecimal actualSalary;
	@ExcelProperty("个税合计")
	private BigDecimal salaryTax;
	@ExcelProperty("年终奖金额合计")
	private BigDecimal annualBonus;
	@ExcelProperty("年终奖扣税合计")
	private BigDecimal annualBonusTax;
	@ExcelProperty("社保合计")
	private BigDecimal allSocial;
	@ExcelProperty("公积金合计")
	private BigDecimal allFund;
	@ExcelProperty("单位社保合计")
	private BigDecimal unitSocial;
	@ExcelProperty("单位公积金合计")
	private BigDecimal unitFund;
	@ExcelProperty("个人社保合计")
	private BigDecimal personSocial;
	@ExcelProperty("个人公积金合计")
	private BigDecimal personFund;
	@ExcelProperty("企业年金")
	private BigDecimal allEnterpriseAnnuity;
	@ExcelProperty("个人年金合计")
	private BigDecimal enterpriseAnnuity;
	@ExcelProperty("单位年金合计")
	private BigDecimal enterpriseAnnuityUnit;
}
