package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.constants.SalaryConstants;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccountItem;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardSet;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardSetDetail;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryAccountItemService;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryStandardSetDetailService;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryStandardSetService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalarySetVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;


/**
 * 工资报账表附加-工资明细
 *
 * @author hgw
 * @date 2019-07-30 15:00:05
 */
@RestController
@AllArgsConstructor
@RequestMapping("/tsalaryaccountitem")
@Tag(name = "工资报账表附加-工资明细")
public class TSalaryAccountItemController {

     private final TSalaryAccountItemService tSalaryAccountItemService;

     private final TSalaryStandardSetService tSalaryStandardSetService;

     private final TSalaryStandardSetDetailService tSalaryStandardSetDetailService;

     /**
      * 简单分页查询
      *
      * @param page               分页对象
      * @param tSalaryAccountItem 工资报账表附加-工资明细
      * @return
      */
     @Operation(description = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TSalaryAccountItem>> getTSalaryAccountItemPage(Page<TSalaryAccountItem> page, TSalaryAccountItem tSalaryAccountItem) {
          return new R<>(tSalaryAccountItemService.getTSalaryAccountItemPage(page, tSalaryAccountItem));
     }

     /**
      * 简单分页查询
      * @author fxj
      * @date 2022-03-11
      * @param tSalaryAccountItem 工资报账表附加-工资明细
      * @return
      */
     @Operation(description = "简单分页查询")
     @GetMapping("/noPage")
     public R<List<TSalaryAccountItem>> getTSalaryAccountItemNoPage(TSalaryAccountItem tSalaryAccountItem) {
          return new R<>(tSalaryAccountItemService.getTSalaryAccountItemNoPage(tSalaryAccountItem));
     }

     /**
      * @param accountId
      * @Description: 获取报账明细
      * @Author: hgw
      * @Date: 2020/5/21 16:01
      * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSalaryAccountItem>
      **/
     @Operation(description = "获取报账明细")
     @PostMapping("/getAccountItemByAccountId")
     public List<TSalaryAccountItem> getAccountItemByAccountId(String accountId) {
          if (Common.isNotNull(accountId)) {
               TSalaryAccountItem item = new TSalaryAccountItem();
               item.setSalaryAccountId(accountId);
               QueryWrapper<TSalaryAccountItem> queryWrapperAi = new QueryWrapper<>();
               queryWrapperAi.setEntity(item);
               return tSalaryAccountItemService.list(queryWrapperAi);
          } else {
               return new ArrayList<>();
          }
     }

     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
     @Operation(description = "id查询")
     @GetMapping("/{id}")
     public R<TSalaryAccountItem> getById(@PathVariable("id") String id) {
          return new R<>(tSalaryAccountItemService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tSalaryAccountItem
      * @return R
      */
     @Operation(description = "新增")
     @SysLog("新增工资报账表附加-工资明细")
     @PostMapping
     @PreAuthorize("@pms.hasPermission('wxhr:tsalaryaccountitem_add')")
     public R save(@RequestBody TSalaryAccountItem tSalaryAccountItem) {
          return new R<>(tSalaryAccountItemService.save(tSalaryAccountItem));
     }

     /**
      * 修改记录
      *
      * @param tSalaryAccountItem
      * @return R
      */
     @Operation(description = "修改")
     @SysLog("修改工资报账表附加-工资明细")
     @PutMapping
     @PreAuthorize("@pms.hasPermission('wxhr:tsalaryaccountitem_edit')")
     public R update(@RequestBody TSalaryAccountItem tSalaryAccountItem) {
          return new R<>(tSalaryAccountItemService.updateById(tSalaryAccountItem));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
     @Operation(description = "删除")
     @SysLog("删除工资报账表附加-工资明细")
     @DeleteMapping("/{id}")
     @PreAuthorize("@pms.hasPermission('wxhr:tsalaryaccountitem_del')")
     public R removeById(@PathVariable String id) {
          return new R<>(tSalaryAccountItemService.removeById(id));
     }

     /**
      * @param accountId 报账id
      * @Description: 获取实发金额
      * @Author: hgw
      * @Date: 2019/11/28 14:53
      * @return: java.math.BigDecimal
      **/
     @Operation(description = "获取实发金额(accountId：报账id)")
     @GetMapping("/getActualMoneyByAccountId")
     public BigDecimal getActualMoneyByAccountId(@RequestParam String accountId) {
          return tSalaryAccountItemService.getMoneyByAccountIdAndJavaFiedName(accountId, SalaryConstants.ACTUAL_SALARY_SUM_JAVA);
     }

     /**
      * @param salaryId
      * @Description: 获取工资明细
      * @Author: hgw
      * @Date: 2021/9/30 18:05
      * @return: java.util.Set<java.lang.String>
      **/
     @Operation(description = "新工资条-获取工资列明细以及配置")
     @GetMapping("/getSalarySet")
     public R<TSalarySetVo> getSalarySet(@RequestParam String salaryId) {
          Set<String> items = tSalaryAccountItemService.getItemSet(salaryId);
          TSalaryStandardSet ss = tSalaryStandardSetService.lambdaQuery()
                  .eq(TSalaryStandardSet::getSalaryId, salaryId).last(" order by CREATE_TIME desc limit 1 ").one();
          if (ss != null && Common.isNotNull(ss.getId())) {
               List<TSalaryStandardSetDetail> detail = tSalaryStandardSetDetailService.list(
                       Wrappers.<TSalaryStandardSetDetail>query().lambda().eq(TSalaryStandardSetDetail::getSetId, ss.getId()).last(" order by order_line asc "));
               ss.setDetailList(detail);
          }
          TSalarySetVo setVo = new TSalarySetVo();
          setVo.setSalaryItem(items);
          setVo.setSalarySet(ss);
          return new R<>(setVo);
     }

}
