/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.FileVo;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAtta;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

/**
 * 薪资结算附件表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
public interface TSalaryAttaService extends IService<TSalaryAtta> {
	/**
	 * 薪资结算附件表简单分页查询
	 *
	 * @param tAtta 薪资结算附件表
	 * @return
	 */
	IPage<TSalaryAtta> getTAttaPage(Page<TSalaryAtta> page, TSalaryAtta tAtta);

	/**
	 * @param linkId   工程工资id
	 * @param recordId 暂停发发放id
	 * @Description: 工程薪资暂停发附件上传
	 * @Author: hgw
	 * @Date: 2021/10/27 15:43
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
	 **/
	R<String> uploadEngineerPauseSalaryAtta(MultipartFile[] file, String filePath, String linkId, Integer linkType
			, Integer[] engineerType, String recordId) throws IOException;

	/**
	 * @param linkId   工资id
	 * @param recordId 自定义暂停发发放id
	 * @Description: 自定义暂停发附件上传
	 * @Author: hgw
	 * @Date: 2021-11-22 17:37:24
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
	 **/
	R<String> uploadPauseDiyAtta(MultipartFile[] file, String filePath, String linkId, Integer linkType
			, String recordId) throws IOException;

	/**
	 * @param linkId 工资id
	 * @Description: 自定义暂停发附件上传
	 * @Author: hgw
	 * @Date: 2021-11-22 17:37:24
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
	 **/
	R<String> uploadLostAndFoundAtta(MultipartFile[] file, String filePath, String linkId, Integer linkType) throws IOException;

	/**
	 * @Description: 薪资附件上传-通用
	 * @Author: hgw
	 * @Date: 2021/10/27 15:43
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
	 **/
	R<FileVo> uploadAtta(MultipartFile file, String filePath, String linkId, Integer linkType, Integer engineerType
			, String printRemark, String recordId) throws IOException;

	/**
	 * @param linkId
	 * @param linkType
	 * @Description: 获取list，并且从oss服务器根据AttaSrc获取路径，塞入AttaUrl
	 * @Author: hgw
	 * @Date: 2021/11/19 16:03
	 * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSalaryAtta>
	 **/
	List<TSalaryAtta> getAttaListHaveSrc(String linkId, Integer linkType);

	List<TSalaryAtta> getAttaListByRecordId(String recordId);

	void updateAttaByLinkId(List<String> salaryAttaIds, String linkId);

	void setSrc(List<TSalaryAtta> attaList);
}
