/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 派单导出Vo
 * @author huyc
 * @date 2022-10-25 10:40:34
 */
@Data
@Schema(description = "派单审核导出Vo")
public class TDispatchAuditExportVo {

	@ExcelAttribute(name = "派单类型", readConverterExp = "0=派增,1=派减")
	@Schema(description = "派单类型：0派增1派减")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("派单类型")
	private String type;

	@ExcelAttribute(name = "员工类型", readConverterExp = "0=外包,1=派遣,2=代理,3=内部员工")
	@Schema(description = "员工类型：0外包1派遣2代理3内部员工")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工类型")
	private String empType;

	@Schema(description = "创建时间")
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建时间")
	private LocalDateTime createTime;

	@ExcelAttribute(name = "员工姓名", maxLength = 50)
	@Schema(description = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;

	@ExcelAttribute(name = "身份证号", maxLength = 20)
	@Schema(description = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;

	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Schema(description = "客户名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String belongUnitName;

	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Schema(description = "项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String settleDomainName;

	@ExcelAttribute(name = "手机号码", maxLength = 32)
	@Schema(description = "手机号码" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("手机号码" )
	private String empMobile;

	@ExcelAttribute(name = "身份证所在地")
	@Schema(description = "身份证所在地" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证所在地" )
	private String idCardAddress;

	@ExcelAttribute(name = "社保户", maxLength = 50)
	@Schema(description = "社保户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户")
	private String socialHouseholdName;

	@ExcelAttribute(name = "公积金户", maxLength = 50)
	@Schema(description = "公积金户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金户")
	private String providentHouseholdName;

	/**
	 * 合同类型（字典值）
	 */
	@ExcelAttribute(name = "合同类型",maxLength = 10)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="合同类型")
	private String contractName;

	/**
	 * 合同起始时间
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "合同起始时间", isDate = true)
	@Schema(description = "合同起始时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同起始时间" )
	private Date contractStart;

	/**
	 * 合同到期时间
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "合同到期时间", isDate = true)
	@Schema(description = "合同到期时间" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同到期时间" )
	private Date contractEnd;

	/**
	 * 工时制：1标准工时 2 综合工时 3不定时工时制
	 */
	@Length(max = 1, message = "工时制 不能超过1个字符" )
	@ExcelAttribute(name = "工时制", maxLength = 1, readConverterExp = "1=标准工时,2=综合工时,3=不定时工时制")
	@Schema(description = "工时制：1标准工时 2 综合工时 3不定时工时制" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工时制" )
	private String workingHours;

	@Schema(description = "创建人姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建人姓名")
	private String createName;

	/**
	 * 委托备注
	 */
	@Length(max = 100, message = "委托备注 不能超过100个字符" )
	@ExcelAttribute(name = "委托备注", maxLength = 100)
	@Schema(description = "委托备注" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("委托备注" )
	private String trustRemark;

	/**
	 * 备案基数
	 */
	@Length(max = 255, message = "备案基数 不能超过255 个字符" )
	@ExcelAttribute(name = "备案基数", maxLength = 255)
	@Schema(description = "备案基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("备案基数" )
	private String recordBase;

	@ExcelAttribute(name = "缴纳类型", readConverterExp = "0=最低,1=自定义,2=最高")
	@Schema(description = "缴纳类型（0最低、1自定义、2最高）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳类型")
	private String paymentType;

	/**
	 * 离职日期
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "离职日期", isDate = true)
	@Schema(description = "离职日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("离职日期" )
	private Date leaveDate;
	/**
	 * 减少原因
	 */
	@ExcelAttribute(name = "减少原因",isNotEmpty = true, isDataId = true,dataType = ExcelAttributeConstants.REDUCE_SOCIAL_REASON)
	@Schema(description = "减少原因" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("减少原因" )
	private String reduceReason;
	/**
	 * 社保起缴日期
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "社保起缴日期", isDate = true)
	@Schema(description = "社保起缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保起缴日期" )
	private Date socialStartDate;
	/**
	 * 公积金起缴日期
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "公积金起缴日期", isDate = true)
	@Schema(description = "公积金起缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金起缴日期" )
	private Date providentStart;
	/**
	 * 社保停缴日期
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "社保停缴日期", isDate = true)
	@Schema(description = "社保停缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保停缴日期" )
	private Date socialReduceDate;

	/**
	 * 公积金停缴日期
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "公积金停缴日期", isDate = true)
	@Schema(description = "公积金停缴日期" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金停缴日期" )
	private Date fundReduceDate;

	/**
	 * 单位养老基数
	 */
	@ExcelAttribute(name = "单位养老基数" )
	@Schema(description = "单位养老基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老基数" )
	private BigDecimal unitPensionCardinal;
	/**
	 * 单位医疗基数
	 */
	@ExcelAttribute(name = "单位医疗基数" )
	@Schema(description = "单位医疗基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗基数" )
	private BigDecimal unitMedicalCardinal;
	/**
	 * 个人养老基数
	 */
	@ExcelAttribute(name = "个人养老基数" )
	@Schema(description = "个人养老基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老基数" )
	private BigDecimal personalPensionCardinal;
	/**
	 * 个人医疗基数
	 */
	@ExcelAttribute(name = "个人医疗基数" )
	@Schema(description = "个人医疗基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗基数" )
	private BigDecimal personalMedicalCardinal;
	/**
	 * 个人失业基数
	 */
	@ExcelAttribute(name = "个人失业基数" )
	@Schema(description = "个人失业基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业基数" )
	private BigDecimal personalUnemploymentCardinal;
	/**
	 * 单位失业基数
	 */
	@ExcelAttribute(name = "单位失业基数" )
	@Schema(description = "单位失业基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业基数" )
	private BigDecimal unitUnemploymentCardinal;
	/**
	 * 单位工伤基数
	 */
	@ExcelAttribute(name = "单位工伤基数" )
	@Schema(description = "单位工伤基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤基数" )
	private BigDecimal unitWorkInjuryCardinal;
	/**
	 * 单位生育基数
	 */
	@ExcelAttribute(name = "单位生育基数" )
	@Schema(description = "单位生育基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育基数" )
	private BigDecimal unitBirthCardinal;
	/**
	 * 单位大病救助金额
	 */
	@ExcelAttribute(name = "单位大病金额" )
	@Schema(description = "单位大病金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病金额" )
	private BigDecimal unitBigailmentMoney;
	/**
	 * 个人大病金额
	 */
	@ExcelAttribute(name = "个人大病金额" )
	@Schema(description = "个人大病金额" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病金额" )
	private BigDecimal personalBigailmentMoney;
	/**
	 * 单位公积金缴纳基数
	 */
	@NotBlank(message = "单位公积金缴纳基数 不能为空" )
	@ExcelAttribute(name = "单位公积金缴纳基数", isNotEmpty = true, errorInfo = "单位公积金缴纳基数 不能为空" )
	@Schema(description = "单位公积金缴纳基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金缴纳基数" )
	private BigDecimal unitProvidengCardinal;
	/**
	 * 个人公积金缴纳基数
	 */
	@NotBlank(message = "个人公积金缴纳基数 不能为空" )
	@ExcelAttribute(name = "个人公积金缴纳基数", isNotEmpty = true, errorInfo = "个人公积金缴纳基数 不能为空" )
	@Schema(description = "个人公积金缴纳基数" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金缴纳基数" )
	private BigDecimal personalProvidentCardinal;
	/**
	 * 单位公积金缴纳比例
	 */
	@ExcelAttribute(name = "单位公积金缴纳比例" )
	@Schema(description = "单位公积金缴纳比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金缴纳比例" )
	private BigDecimal unitProvidentPer;
	/**
	 * 个人公积金缴纳比例
	 */
	@ExcelAttribute(name = "个人公积金缴纳比例" )
	@Schema(description = "个人公积金缴纳比例" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金缴纳比例" )
	private BigDecimal personalProvidentPer;

}
