/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 派单信息记录表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
public class TDispatchInfoPageVo extends TDispatchInfo {

	/**
	 * 社保户名称
	 */
	@ExcelAttribute(name = "社保户名称", maxLength = 50)
	@Schema(description = "社保户名称" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户名称" )
	private String socialHouseholdName;

	/**
	 * 公积金户名称
	 */
	@ExcelAttribute(name = "公积金户名称", maxLength = 50)
	@Schema(description = "公积金户名称" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金户名称" )
	private String providentHouseholdName;

}
