/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

/**
 * 预派单记录
 *
 * @author huyc
 * @date 2022-07-14 18:53:42
 */
@Data
public class TPreDispatchReduceVo {

	/**
	 * 0 派增  1 派减
	 */
	@Schema(description ="派单类型:0 派增  1 派减")
	@NotNull(message = "派单类型不可为空")
	@Size(max = 2, message = "派单类型不可超过2位")
	@ExcelAttribute(name = "派单类型", maxLength = 2)
	private String type;

	/**
	 * 日期，格式：2020-12-25
	 */
	@Schema(description ="日期，格式：2020-12-25")
	@ExcelAttribute(name = "日期", isDate = true)
	private String date;

	/**
	 * 接单分公司
	 */
	@Schema(description ="接单分公司")
	@Size(max = 50, message = "接单分公司不可超过50位")
	@ExcelAttribute(name = "接单分公司", maxLength = 50)
	private String company;

	/**
	 * 缴费地
	 */
	@Schema(description ="缴费地")
	@Size(max = 20, message = "缴费地不可超过20位")
	@ExcelAttribute(name = "缴费地", isNotEmpty = true,errorInfo = "缴费地不能为空", maxLength = 20)
	private String payAddress;

	/**
	 * 客户名称
	 */
	@Schema(description ="客户名称")
	@Size(max = 50, message = "客户名称不可超过50位")
	@ExcelAttribute(name = "客户名称", errorInfo = "客户名称不能为空", maxLength = 50)
	private String customerName;

	/**
	 * 身份证号
	 */
	@Schema(description ="身份证号")
	@NotNull(message = "身份证号码不可为空")
	@Size(max = 20, message = "身份证号码不可超过20位")
	@ExcelAttribute(name = "身份证号", isNotEmpty = true,errorInfo = "身份证号不能为空", maxLength = 20, isIdCard = true)
	private String empIdcard;

	/**
	 * 员工姓名
	 */
	@Schema(description ="员工姓名")
	@NotNull(message = "员工姓名不可为空")
	@Size(max = 20, message = "员工姓名不可超过20位")
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, maxLength = 20)
	private String empName;

	/**
	 * 联系电话1
	 */
	@Schema(description ="联系电话1")
	@Length(max = 11, message = "联系电话1不能超过11个字符")
	@ExcelAttribute(name = "联系电话1", maxLength = 11)
	private String telOne;

	/**
	 * 联系电话2
	 */
	@Schema(description ="联系电话2")
	@Length(max = 11, message = "联系电话2不能超过11个字符")
	@ExcelAttribute(name = "联系电话2", maxLength = 11)
	private String telTwo;

	/**
	 * 入职日期
	 */
	@Schema(description ="入职日期")
	@Size(max = 20, message = "入职日期不可超过20位")
	@ExcelAttribute(name = "入职日期", isDate = true)
	private String entryDate;

	/**
	 * 正式工资
	 */
	@Schema(description ="正式工资")
	@ExcelAttribute(name = "正式工资")
	private String formalSalary;

	/**
	 * 派遣开始日期
	 */
	@Schema(description ="派遣开始日期")
	@Size(max = 20, message = "派遣开始日期不可超过20位")
	@ExcelAttribute(name = "派遣开始日期", maxLength = 20, isDate = true)
	private String dispatchStart;

	/**
	 * 派遣结束日期
	 */
	@Schema(description ="派遣结束日期")
	@Size(max = 20, message = "派遣结束日期不可超过20位")
	@ExcelAttribute(name = "派遣结束日期", maxLength = 20, isDate = true)
	private String dispatchEnd;

	/**
	 * 合同开始日期
	 */
	@Schema(description ="合同开始日期")
	@Size(max = 20, message = "合同开始日期不可超过20位")
	@ExcelAttribute(name = "合同开始日期", maxLength = 20, isDate = true)
	private String contractStart;

	/**
	 * 合同终止日期
	 */
	@Schema(description ="合同终止日期")
	@Size(max = 20, message = "合同终止日期不可超过20位")
	@ExcelAttribute(name = "合同终止日期", isDate = true)
	private String contractEnd;

	/**
	 * 试用开始日期
	 */
	@Schema(description ="试用开始日期")
	@Size(max = 20, message = "试用开始日期不可超过20位")
	@ExcelAttribute(name = "试用开始日期", maxLength = 20, isDate = true)
	private String trialStart;

	/**
	 * 试用结束日期
	 */
	@Schema(description ="试用结束日期")
	@Size(max = 20, message = "试用结束日期不可超过20位")
	@ExcelAttribute(name = "试用结束日期", maxLength = 20, isDate = true)
	private String trialEnd;

	/**
	 * 试用期工资
	 */
	@Schema(description ="试用期工资")
	@ExcelAttribute(name = "试用期工资")
	private String trialSalary;

	/**
	 * 工作制
	 */
	@Schema(description ="工作制")
	@Size(max = 20, message = "工作制不可超过20位")
	@ExcelAttribute(name = "工作制", maxLength = 20)
	private String workingSystem;

	/**
	 * 合同版本
	 */
	@Schema(description ="合同版本")
	@Size(max = 20, message = "合同版本不可超过20位")
	@ExcelAttribute(name = "合同版本", maxLength = 20)
	private String contractVersion;

	/**
	 * 是否电话通知
	 */
	@Schema(description ="是否电话通知")
	@ExcelAttribute(name = "是否电话通知")
	private String telNotice;

	/**
	 * 实际工作地
	 */
	@Schema(description ="实际工作地")
	@Length(max = 20, message = "实际工作地不能超过20个字符")
	@ExcelAttribute(name = "实际工作地")
	private String workingAddress;

	/**
	 * 备注说明1
	 */
	@Schema(description ="备注说明1")
	@Length(max = 250, message = "备注说明1不能超过250个字符")
	@ExcelAttribute(name = "备注说明1", maxLength = 250)
	private String remarkOne;

	/**
	 * 备注说明2
	 */
	@Schema(description ="备注说明2")
	@Length(max = 250, message = "备注说明2不能超过250个字符")
	@ExcelAttribute(name = "备注说明2", maxLength = 250)
	private String remarkTwo;

	/**
	 * 养老基数
	 */
	@Schema(description ="养老基数")
	@ExcelAttribute(name = "养老基数", isFloat = true,max = "99999999.99")
	private BigDecimal pensionBase;

	/**
	 * 养老起缴月
	 */
	@Schema(description ="养老起缴月")
	@Length(max = 6, message = "养老起缴月不能超过6个字符")
	@ExcelAttribute(name = "养老起缴月", maxLength = 6, min = 6, isInteger = true)
	private String pensionStart;

	/**
	 * 医疗基数
	 */
	@Schema(description ="医疗基数")
	@ExcelAttribute(name = "医疗基数", isFloat = true,max = "99999999.99")
	private BigDecimal medicalBase;

	/**
	 * 医疗起缴月
	 */
	@Schema(description ="医疗起缴月")
	@Length(max = 6, message = "医疗起缴月不能超过6个字符")
	@ExcelAttribute(name = "医疗起缴月", maxLength = 6, min = 6, isInteger = true)
	private String medicalStart;

	/**
	 * 工伤城市
	 */
	@Schema(description ="工伤城市")
	@ExcelAttribute(name = "工伤城市")
	private String injuryAddressReduce;

	/**
	 * 工伤基数
	 */
	@Schema(description ="工伤基数")
	@ExcelAttribute(name = "工伤基数", isFloat = true,max = "99999999.99")
	private BigDecimal injuryBase;

	/**
	 * 工伤起缴月
	 */
	@Schema(description ="工伤起缴月")
	@Length(max = 6, message = "工伤起缴月不能超过6个字符")
	@ExcelAttribute(name = "工伤起缴月", maxLength = 6, min = 6, isInteger = true)
	private String injuryStart;

	/**
	 * 生育基数
	 */
	@Schema(description ="生育基数")
	@ExcelAttribute(name = "生育基数", isFloat = true,max = "99999999.99")
	private BigDecimal birthBase;

	/**
	 * 生育起缴月
	 */
	@Schema(description ="生育起缴月")
	@Length(max = 6, message = "生育起缴月不能超过6个字符")
	@ExcelAttribute(name = "生育起缴月", maxLength = 6, min = 6, isInteger = true)
	private String birthStart;

	/**
	 * 失业基数
	 */
	@Schema(description ="失业基数")
	@ExcelAttribute(name = "失业基数", isFloat = true,max = "99999999.99")
	private BigDecimal unemploymentBase;

	/**
	 * 失业起缴月
	 */
	@Schema(description ="失业起缴月")
	@Length(max = 6, message = "失业起缴月不能超过6个字符")
	@ExcelAttribute(name = "失业起缴月", maxLength = 6, min = 6, isInteger = true)
	private String unemploymentStart;

	/**
	 * 公积金基数
	 */
	@Schema(description ="公积金基数")
	@ExcelAttribute(name = "公积金基数", isFloat = true,max = "99999999.99")
	private BigDecimal fundBase;

	/**
	 * 公积金起缴月
	 */
	@Schema(description ="公积金起缴月")
	@Length(max = 6, message = "公积金起缴月不能超过6个字符")
	@ExcelAttribute(name = "公积金起缴月", maxLength = 6, min = 6, isInteger = true)
	private String fundStart;

	/**
	 * 公积金个人比例
	 */
	@Schema(description ="公积金个人比例")
	@ExcelAttribute(name = "公积金个人比例", isFloat = true,max = "100.00")
	private BigDecimal fundPersonalPer;

	/**
	 * 公积金企业比例
	 */
	@Schema(description ="公积金企业比例")
	@ExcelAttribute(name = "公积金企业比例", isFloat = true,max = "100.00")
	private BigDecimal fundCompanyPer;

	/**
	 * 派单分公司
	 */
	@Schema(description ="派单分公司")
	@ExcelAttribute(name = "派单分公司", maxLength = 20)
	private String dispatchCompany;

	/**
	 * 派单客服
	 */
	@Schema(description ="派单客服")
	@Size(max = 20, message = "派单客服不可超过20位")
	@ExcelAttribute(name = "派单客服", maxLength = 20)
	private String customerService;

	/**
	 * 小合同名称
	 */
	@Schema(description ="小合同名称")
	@ExcelAttribute(name = "小合同名称", maxLength = 100)
	private String contractMinorName;

	/**
	 * 唯一号
	 */
	@Schema(description ="唯一号")
	@Size(max = 20, message = "唯一号不可超过20位")
	@ExcelAttribute(name = "唯一号", maxLength = 20)
	private String uniqueNumber;

	/**
	 * 客户编号
	 */
	@Schema(description ="客户编号")
	@ExcelAttribute(name = "客户编号", maxLength = 20)
	private String customerNumber;

	/**
	 * 服务类别
	 */
	@Schema(description ="服务类别")
	@Size(max = 20, message = "服务类别不可超过20位")
	@ExcelAttribute(name = "服务类别", maxLength = 20)
	private String serviceType;

	/**
	 * 养老城市
	 */
	@Schema(description ="养老城市")
	@ExcelAttribute(name = "养老城市", maxLength = 15)
	private String pensionAddressReduce;

	/**
	 * 养老时间
	 */
	@Schema(description ="养老时间")
	@Length(max = 6, message = "养老时间不能超过6个字符")
	@ExcelAttribute(name = "养老时间", maxLength = 6, min = 6, isInteger = true)
	private String pensionEndReduce;

	/**
	 * 医疗城市
	 */
	@Schema(description ="医疗城市")
	@ExcelAttribute(name = "医疗城市", maxLength = 15)
	private String medicalAddressReduce;

	/**
	 * 医疗时间
	 */
	@Schema(description ="医疗时间")
	@Length(max = 6, message = "医疗时间不能超过6个字符")
	@ExcelAttribute(name = "医疗时间", maxLength = 6, min = 6, isInteger = true)
	private String medicalEndReduce;

	/**
	 * 工伤截止时间
	 */
	@Schema(description ="工伤时间")
	@Length(max = 6, message = "工伤时间不能超过6个字符")
	@ExcelAttribute(name = "工伤时间", maxLength = 6, min = 6, isInteger = true)
	private String injuryEndReduce;

	/**
	 * 生育城市
	 */
	@Schema(description ="生育城市")
	@ExcelAttribute(name = "生育城市", maxLength = 15)
	private String birthAddressReduce;

	/**
	 * 生育截止时间
	 */
	@Schema(description ="生育时间")
	@Length(max = 6, message = "生育时间不能超过6个字符")
	@ExcelAttribute(name = "生育时间", maxLength = 6, min = 6, isInteger = true)
	private String birthEndReduce;

	/**
	 * 失业城市
	 */
	@Schema(description ="失业城市")
	@ExcelAttribute(name = "失业城市", maxLength = 15)
	private String unemploymentAddressReduce;

	/**
	 * 失业截止时间
	 */
	@Schema(description ="失业时间")
	@Length(max = 6, message = "失业时间不能超过6个字符")
	@ExcelAttribute(name = "失业时间", maxLength = 6, isInteger = true)
	private String unemploymentEndReduce;

	/**
	 * 公积金城市
	 */
	@Schema(description ="公积金城市")
	@ExcelAttribute(name = "公积金城市", maxLength = 15)
	private String fundAddressReduce;

	/**
	 * 公积金截止时间
	 */
	@Schema(description ="公积金时间")
	@Length(max = 6, message = "公积金时间不能超过6个字符")
	@ExcelAttribute(name = "公积金时间", maxLength = 6, min = 6, isInteger = true)
	private String fundEndReduce;

	/**
	 * 离职日期
	 */
	@Schema(description ="离职日期")
	@ExcelAttribute(name = "离职日期", isDate = true)
	private String leaveDate;

	/**
	 * 离职原因
	 */
	@Schema(description ="离职原因")
	@ExcelAttribute(name = "离职原因")
	private String leaveReason;

	/**
	 * 合同类型
	 */
	@Schema(description ="合同类型")
	@ExcelAttribute(name = "合同类型", maxLength = 20)
	private String contractType;

	/**
	 * 员工类型
	 */
	@Schema(description ="员工类型")
	@Size(max = 20, message = "员工类型不可超过20位")
	@NotNull(message = "员工类型不可为空")
	@ExcelAttribute(name = "员工类型")
	private String empTypeAdd;

	/**
	 * 所属单位ID
	 */
	@Schema(description ="所属单位ID")
	@ExcelAttribute(name = "所属单位ID", maxLength = 32)
	private String unitIdAdd;

	/**
	 * 所属项目ID
	 */
	@Schema(description ="所属项目ID")
	@ExcelAttribute(name = "所属项目ID", maxLength = 32)
	private String departIdAdd;

	/**
	 * 所属单位名称
	 */
	@Schema(description ="所属单位名称")
	@ExcelAttribute(name = "所属单位名称", maxLength = 50)
	private String unitNameAdd;

	/**
	 * 所属项目名称
	 */
	@Schema(description ="所属项目名称")
	@ExcelAttribute(name = "所属项目名称", maxLength = 50)
	private String departNameAdd;

	/**
	 * 社保户
	 */
	@Schema(description ="社保户")
	@ExcelAttribute(name = "社保户")
	private String socialHouseAdd;

	/**
	 * 公积金户
	 */
	@Schema(description ="公积金户")
	@ExcelAttribute(name = "公积金户", maxLength = 50)
	private String fundHouseAdd;

	/**
	 * 备案基数
	 */
	@Schema(description ="备案基数")
	@ExcelAttribute(name = "备案基数", isFloat = true)
	private BigDecimal filingBaseAdd;

	/**
	 * 0:正常未派单1:异常未派单2:已派单
	 */
	@Schema(description ="0:正常未派单1:异常未派单2:已派单")
	@ExcelAttribute(name = "派单状态")
	private String preStatus;

	/**
	 * 0:正常1:作废
	 */
	@Schema(description ="0:正常1:作废")
	@ExcelAttribute(name = "预派单状态", maxLength = 1)
	private String status;

	/**
	 * 异常内容
	 */
	@Schema(description ="异常内容")
	@ExcelAttribute(name = "异常内容")
	private String exceptionContent;

	/**
	 * 社保-省
	 */
	@Schema(description ="社保-省")
	@ExcelAttribute(name = "社保-省")
	private String socialProvince;

	/**
	 * 社保-市
	 */
	@Schema(description ="社保-市")
	@ExcelAttribute(name = "社保-市")
	private String socialCity;

	/**
	 * 社保-县
	 */
	@Schema(description ="社保-县")
	@ExcelAttribute(name = "社保-县")
	private String socialTown;

	/**
	 * 公积金-省
	 */
	@Schema(description ="公积金-省")
	@ExcelAttribute(name = "公积金-省")
	private String fundProvince;

	/**
	 * 公积金-市
	 */
	@Schema(description ="公积金-市")
	@ExcelAttribute(name = "公积金-市")
	private String fundCity;

	/**
	 * 公积金-县
	 */
	@Schema(description ="公积金-县")
	@ExcelAttribute(name = "公积金-县")
	private String fundTown;

	/**
	 * 派单日期限制  在15日前可派单 15日及15后次月派单
	 */
	@Schema(description ="派单日期限制  在15日前可派单 15日及15后次月派单")
	@ExcelAttribute(name = "派单日期限制", isInteger = true)
	private Integer dayLimit;

	/**
	 * 资料是否提交: 0 已提交 1 未提交
	 */
	@Schema(description ="资料是否提交: 0 已提交 1 未提交")
	@NotNull(message = "资料是否提交不可为空")
	@Size(max = 2, message = "资料是否提交不可超过2位")
	@ExcelAttribute(name = "资料是否提交", maxLength = 2)
	private String dataSubStatus;

	/**
	 * 岗位
	 */
	@Schema(description ="岗位")
	@NotNull(message = "岗位不可为空")
	@Size(max = 50, message = "岗位不可超过50位")
	@ExcelAttribute(name = "岗位")
	private String positionAdd;

	/**
	 * 派单的合同名称
	 */
	@Schema(description ="派单的合同名称")
	@ExcelAttribute(name = "派单合同名称")
	private String contractNameAdd;

	/**
	 * 派单的合同类型
	 */
	@Schema(description ="派单的合同类型")
	@ExcelAttribute(name = "派单合同类型")
	private String contractTypeAdd;

	/**
	 * 合同开始时间
	 */
	@Schema(description ="合同开始时间")
	@ExcelAttribute(name = "合同开始时间")
	private String contractStartAdd;

	/**
	 * 合同截止时间
	 */
	@Schema(description ="合同截止时间")
	@ExcelAttribute(name = "合同截止时间")
	private String contractEndAdd;

	/**
	 * 合同期限：默认两年
	 */
	@Schema(description ="合同期限：默认两年")
	@ExcelAttribute(name = "合同期限")
	private String contractTermAdd;

	/**
	 * 工时制：默认综合工时制
	 */
	@Schema(description ="工时制：默认综合工时制")
	private String workingHoursAdd;

	/**
	 * 离职原因（转换后的）
	 */
	@Schema(description ="离职原因（转换后的）")
	private String leaveReasonAdd;

	/**
	 * 备注
	 */
	@Schema(description ="备注")
	@Length(max = 250, message = "备注不能超过250个字符")
	@ExcelAttribute(name = "备注", maxLength = 250)
	private String remark;

	/**
	 * 是否派单：0 是 1 否
	 */
	@Schema(description ="是否派单：0 是 1 否 ")
	@ExcelAttribute(name = "是否派单")
	private String dispatchFlag;

	/**
	 * 取消原因：不派单时填写
	 */
	@Schema(description ="取消原因：不派单时填写")
	@ExcelAttribute(name = "取消原因")
	private String cancelRemark;

	/**
	 * 创建人部门名称
	 */
	@Schema(description ="创建人部门名称")
	@ExcelAttribute(name = "创建人部门名称")
	private String userDeptName;

	/**
	 * 开始时间（查询专用）
	 */
	@ExcelAttribute(name = "创建开始时间")
	@TableField(exist = false)
	private LocalDateTime createTimeStart;
	/**
	 * 截止时间（查询专用）
	 */
	@ExcelAttribute(name = "创建截止时间")
	@TableField(exist = false)
	private LocalDateTime createTimeEnd;

	@TableField(exist = false)
	@Schema(description = "选中的idList")
	private List<String> idList;

	@TableField(exist = false)
	@Schema(description = "导出的表头的Set")
	private Set<String> exportFields;
}
