/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainSelectVo;
import com.yifu.cloud.plus.v1.yifu.social.entity.TIncome;
import com.yifu.cloud.plus.v1.yifu.social.vo.IncomeExportVo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TIncomeSearchVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * 收入明细表
 *
 * @author hgw
 * @date 2022-08-30 17:34:58
 */
@Mapper
public interface TIncomeMapper extends BaseMapper<TIncome> {
    /**
     * 收入明细表简单分页查询
     * @param tIncome 收入明细表
     * @return
     */
    IPage<TIncome> getTIncomePage(Page<TIncome> page, @Param("tIncome") TIncomeSearchVo tIncome);

	List<IncomeExportVo> noPageDiy(@Param("tIncome") TIncomeSearchVo searchVo,
								   @Param("idsStr") List<String> idsStr);

	int noPageCountDiy(@Param("tIncome")TIncomeSearchVo searchVo,
					   @Param("idsStr") List<String> idsStr);

    List<TIncome> getTIncomeList(@Param("tIncome") TIncome tIncome);

	void updateIncomeById(@Param("list") List<TIncome> list);

	/**
	 * @param applyNo
	 * @Description: 删除薪资对应的收入明细
	 * @Author: hgw
	 * @Date: 2022/11/4 17:04
	 * @return: int
	 **/
	int deleteIncomeByApplyNo(@Param("applyNo") String applyNo);

	/**
	 * @param applyNo
	 * @Description: 删除薪资对应的收入明细de明细
	 * @Author: hgw
	 * @Date: 2022/11/4 17:04
	 * @return: int
	 **/
	int deleteIncomeDetailByApplyNo(@Param("applyNo") String applyNo);

	/**
	 * @param idSet
	 * @param dept
	 * @Description: ekp费用划转-收入
	 * @Author: hgw
	 * @Date: 2022/11/17 9:43
	 * @return: int
	 **/
	int changeIncomeDept(@Param("idSet") Set<String> idSet, @Param("dept") TSettleDomainSelectVo dept);

	/**
	 * @param idSet
	 * @param dept
	 * @Description: ekp费用划转-明细
	 * @Author: hgw
	 * @Date: 2022/11/17 9:43
	 * @return: int
	 **/
	int changeIncomeDetailDept(@Param("idSet") Set<String> idSet, @Param("dept") TSettleDomainSelectVo dept);

}
