/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 项目档案所属部门表
 *
 * @author hgw
 * @date 2025-02-28 15:03:17
 */
@Data
public class TEmployeeProjectBelongDeptSearchVo extends EmployeeProjectScpVO {

	/**
	 * 多选导出或删除等操作
	 */
	@Schema(description = "选中ID,多个逗号分割")
	private String ids;

	// 必传：
	@Schema(description = "项目ID")
	private String deptId;

	// 前端传这个
	@Schema(description = "员工所属部门ID逗号分割")
	private String empDeptId;

	// 后端自己转化为arr：员工所属部门ID逗号分割 转化为arr
	private String[] empDeptIdArray;

	@Schema(description = "入离职日期开始时间")
	private LocalDateTime enjoinDateAndLeaveTimeStart;

	@Schema(description = "入离职日期结束时间")
	private LocalDateTime enjoinDateAndLeaveTimeEnd;

	@Schema(description = "商险状态多个")
	private String[] insuranceStatusArray;

	@Schema(description = "合同状态多个")
	private String[] contractStatusArray;

	@Schema(description = "在职状态多个")
	private String[] projectStatusArray;

	@Schema(description = "就职岗位多个")
	private String[] postArray;

	/**
	 * 查询数据起
	 **/
	@Schema(description = "查询limit  开始")
	private int limitStart;
	/**
	 * 查询数据止
	 **/
	@Schema(description = "查询limit  数据条数")
	private int limitEnd;

	@Schema(description = "部门下人员档案数量")
	private Integer empNum;

}
