/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TWorkHandlerInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TWorkHandlerInfoSearchVo;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TWorkHandlerInfoMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TWorkHandlerInfoService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.InsertWorkHandlerVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TWorkHandlerInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
/**
 * 任务处理清单表
 *
 * @author huyc
 * @date 2023-06-15 12:18:28
 */
@Log4j2
@Service
public class TWorkHandlerInfoServiceImpl extends ServiceImpl<TWorkHandlerInfoMapper, TWorkHandlerInfo> implements TWorkHandlerInfoService {

    /**
     * 任务处理清单表简单分页查询
     * @param tWorkHandlerInfo 任务处理清单表
     * @return
     */
    @Override
    public IPage<TWorkHandlerInfo> getTWorkHandlerInfoPage(Page<TWorkHandlerInfo> page, TWorkHandlerInfoSearchVo tWorkHandlerInfo){
        return baseMapper.getTWorkHandlerInfoPage(page,tWorkHandlerInfo);
    }

    /**
     * 任务处理清单表批量导出
     * @param searchVo 任务处理清单表
     * @return
     */
    @Override
    public void listExport(HttpServletResponse response, TWorkHandlerInfoSearchVo searchVo){
        String fileName = "任务处理清单表批量导出" + DateUtil.getThisTime() + ".xlsx";
        //获取要导出的列表
        List<TWorkHandlerInfoVo> list = new ArrayList<>();
        Integer count = baseMapper.noPageCountDiy(searchVo);
        try (ServletOutputStream out = response.getOutputStream()) {
            response.setContentType(CommonConstants.MULTIPART_FORM_DATA);
            response.setCharacterEncoding("utf-8");
            response.setHeader(CommonConstants.CONTENT_DISPOSITION, CommonConstants.ATTACHMENT_FILENAME + URLEncoder.encode(fileName  , CommonConstants.UTF8));
            // 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
			ExcelWriter excelWriter = EasyExcel.write(out, TWorkHandlerInfoVo.class).includeColumnFieldNames(searchVo.getExportFields()).build();

			int index = 0;
            if (count >  CommonConstants.ZERO_INT){
                for (int i = 0; i <= count; i += CommonConstants.EXCEL_EXPORT_LIMIT) {
                    // 获取实际记录
                    searchVo.setLimitStart(i);
                    searchVo.setLimitEnd(CommonConstants.EXCEL_EXPORT_LIMIT);
                    list = baseMapper.noPageDiy(searchVo);
                    if (Common.isNotNull(list)){
                        WriteSheet writeSheet = EasyExcel.writerSheet("任务处理清单表"+index).build();
                        excelWriter.write(list,writeSheet);
                        index++;
                    }
                    if (Common.isNotNull(list)){
                        list.clear();
                    }
                }
            }else {
                WriteSheet writeSheet = EasyExcel.writerSheet("任务处理清单表"+index).build();
                excelWriter.write(list,writeSheet);
            }
            if (Common.isNotNull(list)){
                list.clear();
            }
            excelWriter.finish();
        }catch (Exception e){
            log.error("执行异常" ,e);
        }
    }

	@Override
	public Boolean insertWorkHandler(InsertWorkHandlerVo vo) {
		//增加任务处理情况查询表数据
		TWorkHandlerInfo handlerInfo = new TWorkHandlerInfo();
		handlerInfo.setEmpIdcard(vo.getEmpIdcard());
		handlerInfo.setEmpName(null == vo.getEmpName() ? "" : vo.getEmpName());
		handlerInfo.setDepartName(null == vo.getDepartName() ? "" : vo.getDepartName());
		handlerInfo.setDepartNo(vo.getDepartNo());
		handlerInfo.setInfoFrom("社保派减");
		handlerInfo.setOperUser(vo.getOperUser());
		handlerInfo.setOperTime(LocalDateTime.now());
		handlerInfo.setDetailId(vo.getDetailId());
		handlerInfo.setOperResult(CommonConstants.ZERO_STRING);
		baseMapper.insert(handlerInfo);
		return true;
	}
}
