package com.yifu.cloud.plus.v1.business.controller.system;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.system.SysBusDict;
import com.yifu.cloud.plus.v1.business.service.system.SysBusDictService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.Map;


/**
 * @author fxj
 * @date 2021-08-18 14:51:15
 */
@RestController
@AllArgsConstructor
@RequestMapping("/sysbusdict")
@Tag(name = "B端字典数据表")
public class SysBusDictController {

    private final SysBusDictService sysBusDictService;

    /**
     * 简单分页查询
     *
     * @param page       分页对象
     * @param sysBusDict
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<SysBusDict>> getSysBusDictPage(Page<SysBusDict> page, SysBusDict sysBusDict) {
        return new R<>(sysBusDictService.getSysBusDictPage(page, sysBusDict));
    }


    /**
     * 通过id查询单条记录
     *
     * @param id
     * @return R
     */
    @Operation(description = "id查询")
    @GetMapping("/{id}")
    public R<SysBusDict> getById(@PathVariable("id") String id) {
        return new R<>(sysBusDictService.getById(id));
    }

    /**
     * 新增记录
     *
     * @param sysBusDict
     * @return R
     */
    @Operation(description = "新增(yifu-hro-business:sysbusdict_add)")
    @PostMapping
    @PreAuthorize("@pms.hasPermission('yifu-hro-business:sysbusdict_add')")
    public R<Boolean> save(@Valid @RequestBody SysBusDict sysBusDict) {
        return new R<>(sysBusDictService.save(sysBusDict));
    }

    /**
     * 修改记录
     *
     * @param sysBusDict
     * @return R
     */
    @Operation(description = "修改(yifu-hro-business:sysbusdict_edit)")
    @SysLog("修改")
    @PutMapping
    @PreAuthorize("@pms.hasPermission('yifu-hro-business:sysbusdict_edit')")
    public R<Boolean> update(@RequestBody SysBusDict sysBusDict) {
        return new R<>(sysBusDictService.updateById(sysBusDict));
    }

    /**
     * 通过id删除一条记录
     *
     * @param id
     * @return R
     */
    @Operation(description = "删除(yifu-hro-business:sysbusdict_del)")
    @SysLog("删除")
    @DeleteMapping("/{id}")
    @PreAuthorize("@pms.hasPermission('yifu-hro-business:sysbusdict_del')")
    public R<Boolean> removeById(@PathVariable String id) {
        return new R<>(sysBusDictService.removeById(id));
    }

    /**
     * 获取字典map
     * @param type type:0(key=value  value=label)  1(key=lable value=value)
     * @date 2021-08-24
     * @author fxj
     * @return
     */
    @Operation(description = "B端字典表：返回  map  参数:type:0(key=value  value=label)  1(key=lable value=value)")
    @GetMapping("/getBusiDicMap")
    public R<Map<String,String>> getBusiDicMap(@RequestParam(value = "type", required = true)String type,
                                               @RequestParam(value = "itemType", required = true)String itemType) {
        return sysBusDictService.getBusiDicMap(type,itemType);
    }

}
