package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.SysCspDeptVo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TBusinessEmployeeExtendInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProject;
import com.yifu.cloud.plus.v1.yifu.archives.vo.*;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprArchivesProperties;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TInsuranceUnpurchasePersonCardVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @Author fxj
 * @Date 2022/7/11
 * @Description
 * @Version 1.0
 */
@Log4j2
@EnableConfigurationProperties(DaprArchivesProperties.class)
public class ArchivesDaprUtil {
	@Autowired
	private DaprArchivesProperties daprArchivesProperties;

	public R<Map<String,String>> getCustomerUserMap(List<String> userList){
		R<Map> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/msetttlecustomeruser/inner/getCustomerUserMap" , JSON.toJSONString(userList), Map.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案派单信息失败！");
		}
		Map<String,String> map  = JSON.parseObject(JSON.toJSONString(res.getData()),new TypeReference<HashMap<String,String>>(){});
		return R.ok(map);
	}

	/**
	 * @Author fxj
	 * @Description 获取派单校验需要的档案信息
	 * @Date 21:18 2022/7/18
	 * @Param
	 * @return
	**/
	public R<Map<String, DispatchEmpVo>> getDispatchEmpVo(DispatchCheckVo checkVo){
		R<Map> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/temployeeinfo/getDispatchEmpVo" , JSON.toJSONString(checkVo), Map.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案派单信息失败！");
		}
		Map<String,DispatchEmpVo> map  = JSON.parseObject(JSON.toJSONString(res.getData()),new TypeReference<HashMap<String,DispatchEmpVo>>(){});
		return R.ok(map);
	}
	/**
	 * @Author fxj
	 * @Description 通过项目编码获取项目及客户信息
	 * @Date 21:18 2022/7/20
	 * @Param
	 * @return
	 **/
	public R<SetInfoVo> getSetInfoByCodes(List<String> codes){
		R<SetInfoVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/getSetInfoByCodes",JSON.toJSONString(codes), SetInfoVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案派单信息失败！");
		}
		return res;
	}
	/**
	 * @Author huyc
	 * @Description 通过项目编码获取项目及客户信息
	 * @Date 21:18 2022/7/20
	 * @Param
	 * @return
	 **/
	public R<TSettleDomainListVo> getSettleInfoByCodes(List<String> codes){
		R<TSettleDomainListVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/getSettleInfoByCodes",JSON.toJSONString(codes), TSettleDomainListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("通过项目编码获取项目及客户信息失败！");
		}
		return res;
	}
	/**
	 * @Author fxj
	 * @Description 获取派单校验需要的档案信息
	 * @Date 21:18 2022/7/18
	 * @Param
	 * @return
	 **/
	public R<TSettleDomainSelectVo> getSettleDomainSelectVoById(String departId){
		TSettleDomainSelectVo settleDomainSelectVo = new TSettleDomainSelectVo();
		settleDomainSelectVo.setDepartNo(departId);
		R<TSettleDomainSelectVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/getSettleDomainSelectVoById",settleDomainSelectVo, TSettleDomainSelectVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取派单校验需要的档案信息失败！");
		}
		return res;
	}

	/**
	 * @Author fxj
	 * @Description 获取所有客户单位的项目信息
	 * @Date 21:18 2022/7/18
	 * @Param
	 * @return
	 **/
	public R<TSettleDomainListVo> selectAllSettleDomainSelectVos(){
		R<TSettleDomainListVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/selectAllSettleDomainSelectVos","", TSettleDomainListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取所有客户单位的项目信息失败！");
		}
		return res;
	}

	/**
	 * @Author fxj
	 * @Description 获取所有客户单位的项目信息
	 * @Date 21:18 2022/7/18
	 * @Param
	 * @return
	 **/
	public R<TSettleDomainListVo> selectAllSettleDomainSelectVo(){
		R<TSettleDomainListVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/selectAllSettleDomainSelectVo","", TSettleDomainListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取所有客户单位的项目信息失败！");
		}
		return res;
	}

	/**
	 * @Author fxj
	 * @Description 获取所有客户单位的项目信息
	 * @Date 21:18 2022/7/18
	 * @Param
	 * @return
	 **/
	public R<TSettleDomainListVo> getSettleDomainIdsByUserId(String userId){
		R<TSettleDomainListVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/getSettleDomainIdsByUserId",userId, TSettleDomainListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取所有客户单位的项目信息失败！");
		}
		return res;
	}

	/**
	 * @Author huyc
	 * @Description 根据项目id 获取项目编码
	 * @Date 11:50 2022/8/9
	 * @Param
	 * @return
	 **/
	public R<TSettleDomainListVo> selectSettleDomainSelectVoById(String id){
		TSettleDomainSelectVo settleDomainSelectVo = new TSettleDomainSelectVo();
		settleDomainSelectVo.setId(id);
		R<TSettleDomainListVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/selectSettleDomainSelectVoById",settleDomainSelectVo, TSettleDomainListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("通过项目id获取项目信息失败！");
		}
		return res;
	}

	/**
	 * @Author huyc
	 * @Description 根据项目id 获取项目编码
	 * @Date 11:50 2022/8/9
	 * @Param
	 * @return
	 **/
	public R<TSettleDomainListVo> selectSettleDomainSelectVoByNo(String deptNo){
		TSettleDomainSelectVo settleDomainSelectVo = new TSettleDomainSelectVo();
		settleDomainSelectVo.setDepartNo(deptNo);
		R<TSettleDomainListVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/selectSettleDomainSelectVoByNo",settleDomainSelectVo, TSettleDomainListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("通过项目id获取项目信息失败！");
		}
		return res;
	}

	/**
	 * @param deptNo 部门编码
	 * @Description: 获取部门信息
	 * @Author: hgw
	 * @Date: 2022/11/16 14:50
	 * @return: com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainSelectVo
	 **/
	public TSettleDomainSelectVo selectDeptByNo(String deptNo){
		TSettleDomainSelectVo dept = new TSettleDomainSelectVo();
		dept.setDepartNo(deptNo);
		R<TSettleDomainListVo> listVo = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl()
				, daprArchivesProperties.getAppId(),"/tsettledomain/selectSettleDomainSelectVoByNo"
				, dept, TSettleDomainListVo.class, SecurityConstants.FROM_IN);
		if (Common.isNotNull(listVo) && listVo.getData() != null && listVo.getData().getListSelectVO() != null && !listVo.getData().getListSelectVO().isEmpty()) {
			dept = listVo.getData().getListSelectVO().get(0);
		}
		return dept;
	}

	public R<EmpDispatchAddVo> addDispatchInfo(EmpDispatchAddVo addVo) {
		R<EmpDispatchAddVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/temployeeinfo/addDispatchInfo" , JSON.toJSONString(addVo), EmpDispatchAddVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("新增档案|项目档案|合同信息失败！");
		}
		return res;
	}

	/**
	 * @param empId
	 * @Description: 获取档案基本信息
	 * @Author: hgw
	 * @Date: 2022/7/21 14:48
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo>
	 **/
	public R<TEmployeeInfo> getTEmployeeInfoById(String empId) {
		R<TEmployeeInfo> res = HttpDaprUtil.invokeMethodPost(
				daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId()
				,"/temployeeinfo/inner/getByEmpId" , empId, TEmployeeInfo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案信息失败！");
		}
		return res;
	}

	/**
	 * @param idcard
	 * @Description: 获取档案基本信息
	 * @Author: huyc
	 * @Date: 2022/11/28 14:48
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo>
	 **/
	public R<TEmployeeInfo> getTEmployeeInfoByIdcard(String idcard) {
		R<TEmployeeInfo> res = HttpDaprUtil.invokeMethodPost(
				daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId()
				,"/temployeeinfo/inner/getTEmployeeInfoByIdcard" , idcard, TEmployeeInfo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案信息失败！");
		}
		return res;
	}

	/**
	 * @Description: 获取项目档案基本信息
	 * @Author: hgw
	 * @Date: 2022/7/21 14:48
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo>
	 **/
	public R<TEmployeeProject> getTEmployeeProjectById(TEmployeeProject employeeProject) {
		R<TEmployeeProject> res = HttpDaprUtil.invokeMethodPost(
				daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId()
				,"/temployeeproject/inner/getByEmpIdAndDeptId" , JSON.toJSONString(employeeProject), TEmployeeProject.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案信息失败！");
		}
		return res;
	}

	/**
	 * @param id
	 * @Description: 获取档案合同
	 * @Author: fxj
	 * @Date: 2022/7/25 10:38
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo>
	 **/
	public R<TEmployeeContractInfo> getContractById(String id) {
		R<TEmployeeContractInfo> res = HttpDaprUtil.invokeMethodPost(
				daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId()
				,"/temployeecontractinfo/getContractById" , id, TEmployeeContractInfo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案信息失败！");
		}
		return res;
	}
	/**
	 * @Author fxj
	 * @Description  派单审核通过 同步人员档案 项目档案 合同状态信息
	 * @Date 19:30 2022/8/1
	 * @Param type 0 审核通过  1 审核不通过
	 * @return
	 **/
	public R<Boolean> updateEmpInfo(String empIdCard,String contactAddress, String projectNo, String contractId,String type,String remarkTemp, YifuUser user){
		if (Common.isEmpty(empIdCard)
				|| Common.isEmpty(projectNo)
				|| Common.isEmpty(type)){
			return R.failed(CommonConstants.PARAM_IS_NOT_ERROR);
		}
		UpdateEmpVo vo = new UpdateEmpVo();
		vo.setEmpIdCard(empIdCard);
		vo.setProjectNo(projectNo);
		vo.setContractId(contractId);
		vo.setRemarkTemp(remarkTemp);
		vo.setType(type);
		vo.setCreateBy(user.getId());
		vo.setCreateName(user.getNickname());
		vo.setContactAddress(contactAddress);
		R<Boolean> res = HttpDaprUtil.invokeMethodPost(
				daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId()
				,"/temployeeinfo/inner/updateEmpInfo" , JSON.toJSONString(vo), Boolean.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("更新人员档案、项目档案、合同状态信息失败！");
		}
		return res;
	}
	/**
	 * @Author fxj
	 * @Description 校验手机号码重复
	 * @Date 22:11 2022/8/4
	 * @Param
	 * @return
	**/
	public R<Boolean> checkMobile(String mobile) {
		R<Boolean> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/temployeeinfo/inner/checkMobile" , mobile, Boolean.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("检验号码重复信息失败！");
		}
		return res;
	}

	/**
	 * @Author huyc
	 * @Description 校验手机号码重复
	 * @Date 22:11 2022/8/4
	 * @Param
	 * @return
	 **/
	public R<Boolean> updateEmployeeExtendRedundancy(List<UpdateEmployeeExtendRedundancyDTO> dto) {
		R<Boolean> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/customerBusiness/temployeeBusiness/inner/updateEmployeeExtendRedundancy" , JSON.toJSONString(dto), Boolean.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("更新-对应身份证的冗余信息失败！");
		}
		return res;
	}

	/**
	 * @Author huyc
	 * @Description 获取所有员工拓展表信息
	 * @Date 22:11 2022/8/4
	 * @Param
	 * @return
	 **/
	public R<TBusinessDataListVo> getAllExtendList() {
		R<TBusinessDataListVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/customerBusiness/temployeeBusiness/inner/getAllExtendList" , "", TBusinessDataListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取所有员工拓展表信息失败！");
		}
		return res;
	}

	/**
	 * @Author huyc
	 * @Description 获取所有员工拓展表信息
	 * @Date 22:11 2022/8/4
	 * @Param
	 * @return
	 **/
	public R<TBusinessEmployeeExtendInfo> getExtendByBusinessTelecomNumber(String businessTelecomNumber) {
		R<TBusinessEmployeeExtendInfo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/customerBusiness/temployeeBusiness/inner/getExtendByBusinessTelecomNumber" , businessTelecomNumber, TBusinessEmployeeExtendInfo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("根据电工编号查询扩展表信息失败！");
		}
		return res;
	}

	/**
	 * @Author huyc
	 * @Description 获取所有附属信息
	 * @Date 22:11 2022/8/4
	 * @Param
	 * @return
	 **/
	public R<Map<String, BusinessEmployeeExtendByLeave>> getInfoByLeaveMap() {
		R<Map> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/customerBusiness/temployeeBusiness/inner/getInfoByLeaveMap" , "", Map.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取所有附属信息失败！");
		}
		Map<String,BusinessEmployeeExtendByLeave> map  = JSON.parseObject(JSON.toJSONString(res.getData()),new TypeReference<HashMap<String,BusinessEmployeeExtendByLeave>>(){});
		return R.ok(map);
	}

	/**
	 * @Author huyc
	 * @Description 获取所有非离职员工拓展表信息
	 * @Date 22:11 2022/8/4
	 * @Param
	 * @return
	 **/
	public R<TBusinessDataListVo> getNotLeaveExtendList() {
		R<TBusinessDataListVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/customerBusiness/temployeeBusiness/inner/getNotLeaveExtendList" , "", TBusinessDataListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取所有非离职员工拓展表信息失败！");
		}
		return res;
	}

	/**
	 * @Author fxj
	 * @Description  更新项目档案和人员档案的社保公积金状态
	 * 派增：
	 * 	 * 1、派单处社保或公积金状态为待审核、待办理、办理中，项目档案处社保或公积金状态为处理中1；
	 * 	 * 2、派单处社保或公积金状态为审核不通过或办理失败，项目档案处社保状态为无社保，公积金状态为无公积金0；
	 * 	 * 3、派单处社保状态为部分办理失败，项目档案处社保状态为部分购买 2
	 * 	 * 4、派单处社保或公积金状态为办理成功，项目档案处社保或公积金状态为正常 3
	 * 	 * 派减：
	 * 	 * 1、派减状态为待审核、待办理、审核不通过、办理失败，项目档案处社保或公积金状态不变；
	 * 	 * 2、派减状态为办理成功，项目档案处社保或公积金状态变为已派减 4
	 * 	 * 人员档案处社保或公积金状态根据身份证+项目进行整合：
	 * 	 * 社保状态优先级：正常>部分购买>处理中>已派减>无社保
	 * 	 * 公积金状态优先级：正常>处理中>已派减>无公积金
	 * @Date 19:30 2022/8/1
	 * @Param type 0 审核通过  1 审核不通过
	 * @return
	 **/
	public R<Boolean> updateProjectSocialFund(UpProjectSocialFundVo vo){
		if (Common.isEmpty(vo.getEmpIdCard())
				|| (Common.isEmpty(vo.getSocialStatus())
				&& Common.isEmpty(vo.getFundStatus()))
				|| Common.isEmpty(vo.getDepartNo())){
			return R.failed(CommonConstants.PARAM_IS_NOT_ERROR);
		}
		R<Boolean> res = HttpDaprUtil.invokeMethodPost(
				daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId()
				,"/temployeeproject/inner/updateProjectSocialFund" , JSON.toJSONString(vo), Boolean.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("更新人员档案、项目档案社保公积金状态信息失败！");
		}
		return res;
	}

	public R<Boolean> insertWorkHandler(InsertWorkHandlerVo vo){
		if (Common.isEmpty(vo.getDetailId())
				|| Common.isEmpty(vo.getEmpIdcard())
				|| Common.isEmpty(vo.getDepartNo())){
			return R.failed(CommonConstants.PARAM_IS_NOT_ERROR);
		}
		R<Boolean> res = HttpDaprUtil.invokeMethodPost(
				daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId()
				,"/tworkhandlerinfo/inner/insertWorkHandler" , JSON.toJSONString(vo), Boolean.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("增加任务处理情况查询表数据失败！");
		}
		return res;
	}

	/**
	 * @Description: 更新项目档案的商险状态。商险的status 0无2正常3失效4处理中
	 * @Author: hgw
	 * @Date: 2022/11/23 15:29
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.Boolean>
	 **/
	public R<Boolean> updateEmployeeInsuranceStatus(EmpStatusVo empStatusVo){
		R<Boolean> res = HttpDaprUtil.invokeMethodPost(
				daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId()
				,"/temployeeproject/inner/updateEmployeeInsuranceStatus"
				, JSON.toJSONString(empStatusVo) , Boolean.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("更新【项目档案】的商险状态失败！");
		}
		return res;
	}

	/**
	 * @Description: 仅更新人员档案，项目档案另外更新。商险的status 0无2正常3失效4处理中
	 * @Author: hgw
	 * @Date: 2022-11-23 16:50:41
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.Boolean>
	 **/
	public R<Boolean> updateEmployeeInfoInsuranceStatus(EmpStatusVo empStatusVo){
		R<Boolean> res = HttpDaprUtil.invokeMethodPost(
				daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId()
				,"/temployeeinfo/inner/updateEmployeeInfoInsuranceStatus"
				, JSON.toJSONString(empStatusVo), Boolean.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("更新【人员档案】的商险状态失败！");
		}
		return res;
	}

	/**
	 * @Author fxj
	 * @Description 获取所有客户单位的项目信息
	 * @Date 21:18 2022/7/18
	 * @Param
	 * @return
	 **/
	public R<TSettleDomainListVo> getPermissionByUserId(String userId){
		R<TSettleDomainListVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/getPermissionByUserId",userId, TSettleDomainListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取所有客户单位的项目信息失败！");
		}
		return res;
	}
	/**
	 * @Author fxj
	 * @Description 获取所有客户单位的项目信息
	 * @Date 21:18 2022/7/18
	 * @Param
	 * @return
	 **/
	public R<TSettleDomainListVo> getSettlePermissionForB(String userId){
		R<TSettleDomainListVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/msetttlecustomeruser/getSettlePermissionForB",userId, TSettleDomainListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取B端项目信息失败！");
		}
		return res;
	}

	/**
	 * @Author huyc
	 * @Description 判断是否存在正常的项目
	 * @Date 16:38 2025/1/15
	 * @Param
	 * @return
	 **/
	public R<Boolean> selectExitEmpProject(TInsuranceUnpurchasePersonCardVo cardVo) {
		return HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/temployeeproject/inner/selectExitEmpProject", JSON.toJSONString(cardVo), Boolean.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 新增或者删除项目档案与所属部门的关联表
	 * @Date 17:07 2025/3/10
	 * @Param
	 * @return
	 **/
	public R<Boolean> saveOrDeleteDeptRelation(SysCspDeptVo vo) {
		return HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/temployeeprojectbelongdept/inner/saveOrDeleteDeptRelation", JSON.toJSONString(vo), Boolean.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huych
	 * @Description 获取登录人所有的项目对应的前端客服权限
	 * @Date 15:58 2025/3/13
	 * @Param
	 * @return
	 **/
	public R<TSettleDomainRegistListVo> getAllDeptByCustomerLoginName(String userLoginName){
		R<TSettleDomainRegistListVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/getAllDeptByCustomerLoginName",userLoginName, TSettleDomainRegistListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取项目信息失败！");
		}
		return res;
	}

	/**
	 * @Author huyc
	 * @Description 新增入职待建档信息
	 * @Date 14:34 2025/3/14
	 * @Param
	 * @return
	 **/
	public R<String> saveRegistPreInfo(EmployeeRegistrationPreVo preVo) {
		return HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/employeeregistrationpre/inner/saveRegistPreInfo", JSON.toJSONString(preVo), String.class, SecurityConstants.FROM_IN);
	}

	/**
	 * 获取项目字典项
	 * @param
	 * @author chenyuxi
	 * @since 1.9.8
	 * @Param
	 * @return
	 **/
	public R<SysAutoDictItemVo> getDictListByDeptNo(String deptNo){
		SysAutoDictItemVo dictItemVo = new SysAutoDictItemVo();
		dictItemVo.setDeptNo(deptNo);
		R<SysAutoDictItemVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/sysautodictitem/getSettleDomainSelectVoById",dictItemVo, SysAutoDictItemVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取项目字典项失败！");
		}
		return res;
	}

	/**
	 * @Author fxj
	 * @Description 远程接口获取非在职档案（无档案或已离职）
	 * @Date 10:51 2025/4/24
	**/
	public R<Set<String>> getEmpOnlineMap(List<String> empIdCardList){
		R<Set> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/temployeeinfo/inner/getEmpOnlineMap" , JSON.toJSONString(empIdCardList), Set.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案派单信息失败！");
		}
		Set<String> map  = JSON.parseObject(JSON.toJSONString(res.getData()),new TypeReference<Set<String>>(){});
		return R.ok(map);
	}
}
