package com.yifu.cloud.plus.v1.ekp.controller;

import com.yifu.cloud.plus.v1.ekp.service.EkpRiskInfoService;
import com.yifu.cloud.plus.v1.ekp.vo.EkpIncomePushInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpSocialPushInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpIncomeParamRisk;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * 
 *
 * @author huyc
 * @date 2024-03-13 16:14:37
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/ekpriskinfo" )
@Tag(name = "风险金明细")
public class TEkpRiskInfoController {

    private final EkpRiskInfoService ekpRiskInfoService;

	/**
	 * @param incomeParam
	 * @Description: 推送管理费明细数据
	 * @Author: huyc
	 * @Date: 2024/3/14
	 * @return:
	 **/
	@Inner
	@PostMapping("/inner/pushRiskInfoToEkp")
	public EkpIncomePushInfoVo pushRiskInfoToEkp(@RequestBody EkpIncomeParamRisk incomeParam) {
		return ekpRiskInfoService.pushRiskInfoToEkp(incomeParam);
	}


	/**
	 * @param incomeParam
	 * @Description: 推送管理费明细数据
	 * @Author: huyc
	 * @Date: 2024/3/14
	 * @return:
	 **/
	@Inner
	@PostMapping("/inner/jobPushRiskInfoToEkp")
	public EkpSocialPushInfoVo jobPushRiskInfoToEkp(@RequestBody List<EkpIncomeParamRisk> incomeParam) {
		return ekpRiskInfoService.jobPushRiskInfoToEkp(incomeParam);
	}
}
