package com.yifu.cloud.plus.v1.job.compont;


import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprSalaryProperties;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.HttpDaprUtil;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsBonus;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsDeclarer;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsLabor;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsRemuneration;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @Author huyc
 * @Description 定时任务具体执行类
 * @Date 10:48 2022/8/17
 * @Param
 * @return
 **/
@Component(value = "salaryTask")
@Slf4j
@EnableConfigurationProperties(DaprSalaryProperties.class)
public class SalaryTask {

	@Autowired
	private DaprSalaryProperties daprSalarylProperties;

	/**
	 * @return
	 * @Author huyc
	 * @Description
	 * @Date 10:48 2022/8/17
	 * @Param
	 **/
	public void doStatisticsTaxDeclarer() throws Exception {
		log.info("-------------生成申报对象-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprSalarylProperties.getAppUrl(), daprSalarylProperties.getAppId(),
				"/tstatisticsdeclarer/inner/doStatisticsTaxDeclarer", "", TStatisticsDeclarer.class,
				SecurityConstants.FROM_IN);
		log.info("-------------生成申报对象-定时任务结束------------");
	}

	/**
	 * @return
	 * @Author huyc
	 * @Description
	 * @Date 10:48 2022/8/17
	 * @Param
	 **/
	public void doStatisticsLabor() throws Exception {
		log.info("-------------生成本期劳务费-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprSalarylProperties.getAppUrl(), daprSalarylProperties.getAppId(),
				"/tstatisticslabor/inner/doStatisticsLabor", "", TStatisticsLabor.class,
				SecurityConstants.FROM_IN);
		log.info("-------------生成本期劳务费-定时任务结束------------");
	}

	/**
	 * @return
	 * @Author huyc
	 * @Description
	 * @Date 10:48 2022/8/17
	 * @Param
	 **/
	public void doStatisticsRemuneration() throws Exception {
		log.info("-------------生成本期稿酬-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprSalarylProperties.getAppUrl(), daprSalarylProperties.getAppId(),
				"/tstatisticsremuneration/inner/doStatisticsRemuneration", "",
				TStatisticsRemuneration.class, SecurityConstants.FROM_IN);
		log.info("-------------生成本期稿酬-定时任务结束------------");
	}

	/**
	 * @return
	 * @Author huyc
	 * @Description
	 * @Date 10:48 2022/8/17
	 * @Param
	 **/
	public void doStatisticsBonus() throws Exception {
		log.info("-------------生成全年一次性奖金-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprSalarylProperties.getAppUrl(), daprSalarylProperties.getAppId(),
				"/tstatisticsbonus/inner/doStatisticsBonus", "",
				TStatisticsBonus.class, SecurityConstants.FROM_IN);
		log.info("-------------生成全年一次性奖金-定时任务结束------------");
	}

	/**
	 * @Author fxj
	 * @Description 定时生成有工资无社保数据
	 * @Date 17:31 2022/8/17
	 * @Param
	 * @return
	 **/
	public void createHaveSalaryNoSocial() {
		log.info("------------定时生成时生成有工资无社保数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprSalarylProperties.getAppUrl(),daprSalarylProperties.getAppId(),"/thavesalarynosocial/inner/generate","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成时生成有工资无社保数据-定时任务结束------------");
	}

	/**
	 * @Author fxj
	 * @Description 定时生成最低工资提醒数据
	 * @Date 17:31 2022/8/17
	 * @Param
	 * @return
	 **/
	public void createSysMessageSalary() {
		log.info("------------定时生成时生成最低工资提醒数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprSalarylProperties.getAppUrl(),daprSalarylProperties.getAppId(),"/sysmessagesalary/inner/createSysMessageSalary","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成时生成最低工资提醒数据-定时任务结束------------");
	}

	/**
	 * @Author hgw
	 * @Description 定时生成本期申报
	 * @Date 2022-8-23 16:36:51
	 * @Param
	 * @return
	 **/
	public void doRefreshStatisticsTaxAuto() {
		log.info("------------定时生成本期申报-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprSalarylProperties.getAppUrl(),daprSalarylProperties.getAppId(),"/tstatisticstaxsalary/inner/doRefreshStatisticsTaxAuto","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成本期申报-定时任务结束------------");
	}

	/**
	 * @Author hgw
	 * @Description 前12月平均工资（MVP-TDC接口）
	 * @Date 2023-6-19 16:31:32
	 * @Param
	 * @return
	 **/
	public void doCreateAverageSalary() {
		log.info("------------定时生成【前12月平均工资】-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprSalarylProperties.getAppUrl(),daprSalarylProperties.getAppId(),"/taveragesalary/inner/doCreateAverageSalary","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成【前12月平均工资】-定时任务结束------------");
	}

	/**
	 * @Author hgw
	 * @Description 定时任务刷新【不购买商险申请明细】里的社保状态
	 * @Date 2025-1-15 16:58:10
	 **/
	public void doSocialWorkInjuryHandleAll() {
		log.info("------------定时任务刷新不购买里的社保状态-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprSalarylProperties.getAppUrl(),daprSalarylProperties.getAppId(),"/tinsuranceunpurchaseperson/inner/doSocialWorkInjuryHandleAll","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时任务刷新不购买里的社保状态-定时任务结束------------");
	}


}