/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.msg.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.msg.config.WxConfig;
import com.yifu.cloud.plus.v1.msg.entity.TMessageInfo;
import com.yifu.cloud.plus.v1.msg.mapper.TMessageInfoMapper;
import com.yifu.cloud.plus.v1.msg.service.TMessageInfoService;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysUser;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.UpmsDaprUtils;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import lombok.AllArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

/**
 * 消息提醒
 *
 * @author huyc
 * @date 2023-07-26 14:19:33
 */
@Log4j2
@Service
@AllArgsConstructor
public class TMessageInfoServiceImpl extends ServiceImpl<TMessageInfoMapper, TMessageInfo> implements TMessageInfoService {

	@Autowired
	private final UpmsDaprUtils upmsDaprUtils;

	@Autowired
	private WxConfig wxConfig;

    /**
     * 消息提醒简单分页查询
     * @param tMessageInfo 消息提醒
     * @return
     */
    @Override
    public IPage<TMessageInfo> getTMessageInfoPage(Page<TMessageInfo> page, TMessageInfo tMessageInfo){
        return baseMapper.getTMessageInfoPage(page,tMessageInfo);
    }

	@Override
	public R<Boolean> saveMessage(TMessageInfo tMessageInfo) {
		//企业微信通知
		if (CommonConstants.ZERO_STRING.equals(tMessageInfo.getWxFlag())) {
			//获取人员的账号
			R<SysUser> simpleUser = upmsDaprUtils.getSimpleUser(tMessageInfo.getAlertUserId());
			if(null != simpleUser && null != simpleUser.getData()) {
				SysUser user = simpleUser.getData();
				if (Common.isEmpty(user) || Common.isEmpty(user.getWxMessage())) {
					return R.failed("未找到对应的人员信息");
				} else {
					RestTemplate restTemplate = new RestTemplate();
					Map<String, Object> textcard = new HashMap<>();
					Map<String, Object> requestMap = new HashMap<>();
					String authUrl = String.format(SecurityConstants.WX_GET_MESSAGE_AUTH_URL, wxConfig.getCorpid(), wxConfig.getAuthUrl(), CommonConstants.ONE_STRING + tMessageInfo.getModelId());
					textcard.put("title", "审批待处理");
					textcard.put("url", authUrl);
					StringBuilder description = new StringBuilder();
					description.append("申请人：").append(tMessageInfo.getSubmitUser()).append("<br>");
					description.append("待处理人：").append(tMessageInfo.getAlertUser()).append("<br>");
					description.append("模块：").append(tMessageInfo.getModelType());
					textcard.put("description", description.toString());
					requestMap.put("touser", user.getWxMessage());
					requestMap.put("agentid", wxConfig.getAgentid());
					requestMap.put("msgtype", "textcard");
					requestMap.put("textcard", textcard);
					// 必须加上header说明
					if (!wxConfig.sendTextCard(restTemplate, requestMap)) {
						wxConfig.sendTextCard(restTemplate, requestMap);
					}
				}
			}
		}
		baseMapper.insert(tMessageInfo);
		return R.ok();
	}

	@Override
	public void updateMessageInfo(TMessageInfo tMessageInfo) {
		if (Common.isNotNull(tMessageInfo) && Common.isNotNull(tMessageInfo.getAlertUser())) {
			TMessageInfo tMessageInfo1 = null;
			if (Common.isNotNull(tMessageInfo.getModelId())) {
				tMessageInfo1 = baseMapper.selectOne(Wrappers.<TMessageInfo>query().lambda()
						.eq(TMessageInfo::getAlertUser, tMessageInfo.getAlertUser())
						.eq(TMessageInfo::getModelId, tMessageInfo.getModelId())
						.orderByDesc(TMessageInfo::getCreateTime).last(CommonConstants.LAST_ONE_SQL));
			} else if (Common.isNotNull(tMessageInfo.getInfoUrl())){
				tMessageInfo1 = baseMapper.selectOne(Wrappers.<TMessageInfo>query().lambda()
						.eq(TMessageInfo::getAlertUser, tMessageInfo.getAlertUser())
						.eq(TMessageInfo::getInfoUrl, tMessageInfo.getInfoUrl())
						.orderByDesc(TMessageInfo::getCreateTime).last(CommonConstants.LAST_ONE_SQL));
			}
			if (Common.isNotNull(tMessageInfo1)) {
				tMessageInfo1.setHandlerStatus(tMessageInfo.getHandlerStatus());
			}
		}
	}

	@Override
	public R<Long> selectMessageCount(TMessageInfo tMessageInfo) {
		YifuUser user = SecurityUtils.getUser();
		return R.ok(baseMapper.selectCount(Wrappers.<TMessageInfo>query().lambda()
				.eq(TMessageInfo::getAlertUserId,user.getId())
				.eq(TMessageInfo::getHandlerStatus,CommonConstants.ONE_STRING)));
	}
}
