/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsTaxSalary;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TStatisticsTaxSalarySearchVo;

import javax.servlet.http.HttpServletResponse;

/**
 * 统计-工资薪金
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
public interface TStatisticsTaxSalaryService extends IService<TStatisticsTaxSalary> {
    /**
     * 统计-工资薪金简单分页查询
     * @param tStatisticsTaxSalary 统计-工资薪金
     * @return
     */
    IPage<TStatisticsTaxSalary> getTStatisticsTaxSalaryPage(Page<TStatisticsTaxSalary> page, TStatisticsTaxSalarySearchVo tStatisticsTaxSalary);

    void listExport(HttpServletResponse response, TStatisticsTaxSalarySearchVo searchVo);

	/**
	 * @param declareMonth 申报月
	 * @Description: 手动刷新-年度报账+工资薪金+本期申报
	 * @Author: hgw
	 * @Date: 2022/2/22 16:22
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
	 **/
	R<String> doRefreshStatisticsTaxAll(String declareMonth);

}
