package com.yifu.cloud.plus.v1.yifu.archives.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;
import lombok.ToString;

import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 
 * @TableName t_business_employee_extend_info
 */
@TableName(value ="t_business_employee_extend_info")
@Data
@ToString
public class TBusinessEmployeeExtendInfo extends Model<TBusinessEmployeeExtendInfo> {
    /**
     * 主键
     */
	@TableId(type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 身份证号码
     */
    private String empIdcard;

    /**
     * 姓名
     */
    private String empName;

    /**
     * 部门名称
     */
    private String departName;

    /**
     * 部门id
     */
    private Integer departId;


    /**
     * 部门编码 对应部门实体中的TreeLogo
     */
    private String departCode;

    /**
     * b端岗位
     */
    private String businessPost;

    /**
     * b端员工工号
     */
    private String businessTelecomNumber;

    /**
     * 标签，字典值（英文逗号分割）
     */
    private String employeeTags;

    /**
     * 第一学历和专业
     */
    private String firstDegreeAndMajor;

    /**
     * 第一学历院校
     */
    private String firstDegreeGraduateSchool;

    /**
     * 最高学历和专业
     */
    private String highestDegreeAndMajor;

    /**
     * 最高学历院校
     */
    private String highestDegreeGraduateSchool;

    /**
     * 联系方式
     */
    private String contactInfo;

    /**
     * 档案所在地
     */
    private String archivesAddr;

    /**
     * 0在职 1离职 3 临时
     */
    private String businessWorkingStatus;


    /**
     * B端维护的离职时间
     */
    private LocalDate businessLeaveDate;

    /**
     * B端维护的入职时间
     */
    private LocalDate businessEnjoinDate;

    /**
     * B端维护的离职原因
     */
    private String businessLeaveReason;

    /**
     * 0未删除 1已删除
     */
    @TableLogic
    private String deleteFlag;

    /**
     * 证件类型
     */
    private String documentType;

    /**
     * @description: dto转实体
     * @param dtoList
     * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.basic.TBusinessEmployeeExtendInfo>
     * @author: wangweiguo
     * @date: 2021/8/10
     */
    public static List<TBusinessEmployeeExtendInfo> covertDtoListToList(Collection<?> dtoList) {
        return dtoList.stream().map(o -> {
            TBusinessEmployeeExtendInfo entity = new TBusinessEmployeeExtendInfo();
            BeanUtil.copyProperties(o, entity, CopyOptions.create().setIgnoreNullValue(true));
            return entity;
        }).collect(Collectors.toList());
    }

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}