package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 合同待签订任务记录表
 *
 * @author huych
 * @date 2025-06-11 14:15:53
 */
@Data
@TableName("t_employee_contract_pre")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "合同待签订任务记录表")
public class TEmployeeContractPre extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "id")
	private String id;

	@Schema(description = "项目名称")
	private String deptName;

	@Schema(description = "项目编码")
	private String deptNo;

	@Schema(description = "项目id")
	private String deptId;

	@Schema(description = "员工姓名")
	private String employeeName;

	@Schema(description = "身份证号")
	private String empIdcard;

	@Schema(description = "手机号码")
	private String empPhone;

	@Schema(description = "就职岗位")
	private String position;

	@Schema(description = "入职日期")
	@JsonFormat(shape= JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd", timezone = "GMT+08:00")
	private Date joinLeaveDate;

	@Schema(description = "合同类型,标准合同/劳务协议/实习协议/劳务派遣合同/非全日制/其他合同")
	private String contractType;

	@Schema(description = "状态,0待确认,1待发起,2线下签待审核,3线下签审核不通过4线下签待归档5发起失败6签署中7签署失败8电子待归档9已完结10撤销签署")
	private String processStatus;

	@Schema(description = "签署甲方")
	private String signatory;

	@Schema(description = "前端客服")
	private String customerUsername;

	@Schema(description = "前端客服登录名")
	private String customerUserLoginname;

	@Schema(description = "签署方式1线下签0电子签")
	private String signType;

	@Schema(description = "是否撤销签署0是1否")
	private String signFlag;

	@Schema(description = "撤销签署原因")
	private String revokeReason;

	@Schema(description = "发起失败原因")
	private String errorInfo;

	@Schema(description = "发起失败时间")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Date errorTime;

	@Schema(description = "法大大模版名称")
	private String fadadaTemplate;

	@Schema(description = "数据来源1客户端 2客服端")
	private String dataSource;

	/**
	 * 预计确认时间
	 */
	@Schema(description = "预计确认时间")
	@JsonFormat(shape= JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
	private LocalDateTime expectedConfirmTime;

	@Schema(description = "预计发起时间")
	@JsonFormat(shape= JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
	private LocalDateTime expectedCollectionTime;

	@Schema(description = "合同起始时间")
	@JsonFormat(shape= JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd", timezone = "GMT+08:00")
	private Date contractStart;

	@Schema(description = "合同到期时间")
	@JsonFormat(shape= JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd", timezone = "GMT+08:00")
	private Date contractEnd;

	@Schema(description = "签订类型")
	private String situation;

	@Schema(description = "签订期限 0已完成一定工作任务为期限、1固定期限、2无固定期限")
	private String contractTerm;

	@Schema(description = "合同年限-年")
	private String contractDurationYear;

	@Schema(description = "合同年限-月")
	private String contractDurationMonth;

	@Schema(description = "合同试用期开始时间")
	@JsonFormat(shape= JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd", timezone = "GMT+08:00")
	private Date tryPeriodStart;

	@Schema(description = "合同试用期结束时间")
	@JsonFormat(shape= JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd", timezone = "GMT+08:00")
	private Date tryPeriodEnd;

	@Schema(description = "工作任务")
	private String task;

	@Schema(description = "任务类型： 0 不同员工不同任务自定义 1 所有员工任务相同")
	private String taskType;

	@Schema(description = "结束任务标准")
	private String taskEndStandard;

	@Schema(description = "配置名称")
	private String configName;

	@Schema(description = "是否允许修改 0是 1否")
	private String updateFlag;

	@Schema(description = "是否有试用期 0是1否")
	private String tryPeriodType;

	@Schema(description = "试用期（单位月）")
	private String tryPeriod;

	@Schema(description = "试用期工资 元/月")
	private BigDecimal periodSalaryPerMonth;

	@Schema(description = "工资形式 1.计时工资 2.计件工资 3.其他")
	private String salaryType;

	@Schema(description = "计时工资 工资标准 元/月 ")
	private BigDecimal salaryStandardPerHour;

	@Schema(description = "计件工资 工资标准单价/元 ")
	private BigDecimal salaryStandardPerPiece;

	@Schema(description = "配置id")
	private String configId;

	@Schema(description = "工作部门")
	private String workingDept;

	@Schema(description = "用工单位名称")
	private String workingCompany;

	@Schema(description = "工时制（数据字典） 1标准工时 2 综合工时 3不定时工时制")
	private String workingHours;

	@Schema(description = "试用期工资(元/月)")
	private String workingReward;

	@Schema(description = "购买补充保险说明")
	private String riskBuyDesc;

	@Schema(description = "其他  (工资形式其他时的工资)")
	private String otherWage;

	@Schema(description = "劳务费（元/月）")
	private String laborCost;

	@Schema(description = "违约责任（金额）")
	private String defaultAmount;

	@Schema(description = "工资结算周期")
	private String settlementCycle;

	@Schema(description = "工资发放时间")
	private String paymentTime;

	@Schema(description = "工资发放方式 0 直接发放/1委托银行代发")
	private String paymentType;

	@Schema(description = "派遣期限-年")
	private String dispatchPeriodYear;

	@Schema(description = "派遣期限-月")
	private String dispatchPeriodMonth;

	@Schema(description = "派遣开始日期")
	private Date dispatchPeriodStart;

	@Schema(description = "派遣结束日期")
	private Date dispatchPeriodEnd;

	@Schema(description = "工作方式 0 第一种方式 1 第二种方式")
	private String workType;

	@Schema(description = "每周工作天数")
	private String workDayCount;

	@Schema(description = "每周工作日")
	private String workDay;

	@Schema(description = "每日工作时长")
	private String workHours;

	@Schema(description = "其他工作时间 （工作方式为第二种方式）")
	private String otherWorkDay;

	@Schema(description = "实习期限 无/一个月/两个月.../十二个月")
	private String internshipPeriod;

	@Schema(description = "实习开始日期")
	private Date internshipPeriodStart;

	@Schema(description = "实习结束日期")
	private Date internshipPeriodEnd;

	@Schema(description = "合同岗位 0 固定岗位 1 等于档案处维护 2 自定义")
	private String postType;

	@Schema(description = "入职确认选择  0 配置方案内选择、1 自定义 2 配置方案+自定义")
	private String confirmEmpSelect;

	@Schema(description = "超时未确认是否触发签署任务(电子签)  0 自动触发 1 不触发")
	private String timeoutElecSign;

	@Schema(description = "合同截止日期类型 0合同年限推算/1同商务合同一致/2已完成固定工作位期限")
	private String contractEndType;

	@Schema(description = "合同岗位名称")
	private String post;

	@Schema(description = "关联合同id")
	private String contractId;

	@Schema(description = "工作地点")
	private String workAddress;

	@Schema(description = "入离职登记主表id")
	private String registerId;

	@Schema(description = "是否已签署合同 0是1否")
	private String contractFlag;

	@Schema(description = "新合同发起时间 入职日期 0、入职3天后 3、入职1周后 7、入职2周后 14、入职3周后 21")
	@TableField(exist = false)
	private int registType;

	@Schema(description = "试用期月份数字 1、2、3、4...")
	@TableField(exist = false)
	private String tryPeriodNum;

	@Schema(description = "实习期限月数 0、1、2、3...")
	@TableField(exist = false)
	private String internshipPeriodNum;

	@Schema(description = "附件集合")
	@TableField(exist = false)
	private List<TAttaInfo> attaList;

}
