/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import lombok.Data;

import java.io.Serializable;

/**
 * 瓜子档案表——导出教育经历
 *
 * @author hgw
 * @date 2025-6-19 15:09:18
 */
@Data
@ColumnWidth(15)
public class TGzEmpInfoExportEducation implements Serializable {

	// 流程ID	姓名	证件号码	学历	学位	教育方式	院校名称	入学日期	毕业日期	毕业类型	专业	是否最高学历	是否最高学位	是否第一学历
	@ExcelProperty("流程ID")
	private String bizId;
	@ExcelProperty("姓名")
	private String name;
	@ExcelProperty("证件号码")
	private String nationalId;

	@ExcelAttribute(name = "学历", isDataId = true, dataType = ExcelAttributeConstants.GZ_EDU_QUAL)
	@ExcelProperty("学历")
	private String eduQual;
	@ExcelAttribute(name = "学位", isDataId = true, dataType = ExcelAttributeConstants.GZ_EDU_DERGEE)
	@ExcelProperty("学位")
	private String eduDegree;
	@ExcelAttribute(name = "教育方式", isDataId = true, dataType = ExcelAttributeConstants.GZ_EDU_TYPE)
	@ExcelProperty("教育方式")
	private String eduType;
	@ExcelProperty("院校名称")
	private String school;

	// 日期格式化
	@ExcelProperty("入学日期")
	private String eduStartDate;
	// 日期格式化
	@ExcelProperty("毕业日期")
	private String eduEndDate;

	@ExcelAttribute(name = "毕业类型", isDataId = true, dataType = ExcelAttributeConstants.GZ_GRADUATE_TYPE)
	@ExcelProperty("毕业类型")
	private String gradutionType;
	@ExcelProperty("专业")
	private String major;
	@ExcelAttribute(name = "是否最高学历", isDataId = true, readConverterExp = "Y=是,N=不是")
	@ExcelProperty("是否最高学历")
	private String highEduQualFlag;
	@ExcelAttribute(name = "是否最高学位", isDataId = true, readConverterExp = "Y=是,N=不是")
	@ExcelProperty("是否最高学位")
	private String highEduDegreeFlag;
	@ExcelAttribute(name = "是否第一学历", isDataId = true, readConverterExp = "Y=是,N=不是")
	@ExcelProperty("是否第一学历")
	private String firstDegreeFlag;

}
