/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.admin.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysOutEmpCategorizeFormInfo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysOutEmpCategorizeFormInfoService;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;


/**
 * 瓜子采集表单信息分类表
 *
 * @author chenyx
 * @date 2025-06-11 15:57:30
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/sysoutempcategorizeforminfo" )
@Tag(name = "瓜子采集表单信息分类表管理")
public class SysOutEmpCategorizeFormInfoController {

    private final  SysOutEmpCategorizeFormInfoService sysOutEmpCategorizeFormInfoService;

    /**
     * 简单分页查询
     * @param page 分页对象
     * @param sysOutEmpCategorizeFormInfo 瓜子采集表单信息分类表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<SysOutEmpCategorizeFormInfo>> getSysOutEmpCategorizeFormInfoPage(Page<SysOutEmpCategorizeFormInfo> page, SysOutEmpCategorizeFormInfo sysOutEmpCategorizeFormInfo) {
        return  new R<>(sysOutEmpCategorizeFormInfoService.getSysOutEmpCategorizeFormInfoPage(page,sysOutEmpCategorizeFormInfo));
    }


    /**
     * 通过id查询瓜子采集表单信息分类表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('admin_sysoutempcategorizeforminfo_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('admin_sysoutempcategorizeforminfo_get')" )
    public R<SysOutEmpCategorizeFormInfo> getById(@PathVariable("id" ) String id) {
        return R.ok(sysOutEmpCategorizeFormInfoService.getById(id));
    }

    /**
     * 新增瓜子采集表单信息分类表
     * @param sysOutEmpCategorizeFormInfo 瓜子采集表单信息分类表
     * @return R
     */
    @Operation(summary = "新增瓜子采集表单信息分类表", description = "新增瓜子采集表单信息分类表：hasPermission('admin_sysoutempcategorizeforminfo_add')")
    @SysLog("新增瓜子采集表单信息分类表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('admin_sysoutempcategorizeforminfo_add')" )
    public R<Boolean> save(@RequestBody SysOutEmpCategorizeFormInfo sysOutEmpCategorizeFormInfo) {
        return R.ok(sysOutEmpCategorizeFormInfoService.save(sysOutEmpCategorizeFormInfo));
    }

    /**
     * 修改瓜子采集表单信息分类表
     * @param sysOutEmpCategorizeFormInfo 瓜子采集表单信息分类表
     * @return R
     */
    @Operation(summary = "修改瓜子采集表单信息分类表", description = "修改瓜子采集表单信息分类表：hasPermission('admin_sysoutempcategorizeforminfo_edit')")
    @SysLog("修改瓜子采集表单信息分类表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('admin_sysoutempcategorizeforminfo_edit')" )
    public R<Boolean> updateById(@RequestBody SysOutEmpCategorizeFormInfo sysOutEmpCategorizeFormInfo) {
        return R.ok(sysOutEmpCategorizeFormInfoService.updateById(sysOutEmpCategorizeFormInfo));
    }

    /**
     * 通过id删除瓜子采集表单信息分类表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除瓜子采集表单信息分类表", description = "通过id删除瓜子采集表单信息分类表：hasPermission('admin_sysoutempcategorizeforminfo_del')")
    @SysLog("通过id删除瓜子采集表单信息分类表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('admin_sysoutempcategorizeforminfo_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(sysOutEmpCategorizeFormInfoService.removeById(id));
    }

}
