package com.yifu.cloud.plus.v1.yifu.archives.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TBusinessEmployeeExtendInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProject;
import com.yifu.cloud.plus.v1.yifu.archives.vo.BusinessEmployeeExtendByLeave;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TBusinessDataListVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.UpdateEmployeeExtendRedundancyDTO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description: b端员工信息拓展信息 service
 * @author: wangweiguo
 * @date: 2021/8/6
 */
public interface TBusinessEmployeeExtendInfoService extends IService<TBusinessEmployeeExtendInfo> {
    /**
     * 更新人员信息冗余字段
     * @description: 更新人员信息冗余字段
     * @param dto
     * @return: Boolean
     * @author: wangweiguo
     * @date: 2021/8/12
     */
    Boolean updateEmployeeExtendRedundancy(List<UpdateEmployeeExtendRedundancyDTO> dto);
	/**
	 * @description: 根据身份证号查询人员拓展表信息
	 * @param empIdcard 身份证号
	 * @return: com.yifu.cloud.v1.hrms.api.entity.basic.TBusinessEmployeeExtendInfo
	 * @author: wangweiguo
	 * @date: 2021/8/10
	 */
	TBusinessEmployeeExtendInfo getByEmpIdCard(String empIdcard);

	/**
	 * @param businessTelecomNumber
	 * @Description: 根据工号返回附属信息
	 * @Author: hgw
	 * @Date: 2021/8/18 17:03
	 * @return: com.yifu.cloud.v1.hrms.api.entity.basic.TBusinessEmployeeExtendInfo
	 **/
	TBusinessEmployeeExtendInfo getByBusinessTelecomNumber(String businessTelecomNumber);

	/**
	 * 根据jsonStr批量更新人员信息拓展表信息
	 * @description:
	 * @param jsonStr
	 * @param empInfoMap
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.Boolean>
	 * @author: wangweiguo
	 * @date: 2021/8/10
	 */
	R<List<ErrorMessage>> batchUpdateEmployeeExtendByJsonStr(String jsonStr, HashMap<String, TEmployeeProject> empInfoMap);

	/**
	 * 根据身份证号获取拓展信息列表
	 * @description: 根据身份证号获取拓展信息列表
	 * @param idCardList
	 * @return: com.yifu.cloud.v1.common.core.util.R<List<TBusinessEmployeeExtendInfo>>
	 * @author: wangweiguo
	 * @date: 2021/8/16
	 */
	List<TBusinessEmployeeExtendInfo> getListByIdCardList(List<String> idCardList);

	/**
	 * 查询-列表：内部服务调用，获取所有非离职员工拓展表信息
	 * @description: 查询-列表：内部服务调用，获取所有非离职员工拓展表信息
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.util.List<com.yifu.cloud.v1.hrms.api.vo.basic.BusinessEmployeeExtendVO>>
	 * @author: wangweiguo
	 * @date: 2021/8/17
	 */
	TBusinessDataListVo getNotLeaveExtendList();

	/**
	 * @param
	 * @Description: 获取所有附属信息
	 * @Author: hgw
	 * @Date: 2021/8/18 16:45
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.util.Map < java.lang.String, com.yifu.cloud.v1.hrms.api.vo.basic.BusinessEmployeeExtendByLeave>>
	 **/
	Map<String, BusinessEmployeeExtendByLeave> getInfoByLeaveMap();

	/**
	 * b端人员信息编辑拓展信息
	 * @description: b端人员信息编辑拓展信息
	 * @param tBusinessEmployeeExtendInfo 实体
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.Boolean>
	 * @author: wangweiguo
	 * @date: 2021/8/19
	 */
	R<Boolean> saveOrUpdateData(TBusinessEmployeeExtendInfo tBusinessEmployeeExtendInfo);

	boolean updateEmpExtendCertInfo(UpdateEmployeeExtendRedundancyDTO dto);

	TBusinessEmployeeExtendInfo getDataById(String extendId);
}
