/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 工资报账主表（工资条）
 *
 * @author hgw
 * @date 2023-2-17 17:41:43
 */
@Data
@Schema(description = "工资报账导出-审核人专用")
@HeadFontStyle(fontHeightInPoints = 11)
public class TSalaryAccountExportVo {
	private String id;

	private String salaryFormId;
	// 是否劳务费	手机号	计税月份	发放时间	结算月份	工资月份	出账单位	结算单位	结算单位编码
	// 结算部门	部门编码	人员类型	在职状态	员工姓名	身份证号	工资应发	实发工资合计
	// 年终奖	薪资个税	年终奖扣税	代扣个人社保	代扣个人公积金	个人社保	个人公积金
	// 免个税个人代扣	企业（职业）年金	单位社保	单位公积金	代扣单位社保	代扣单位公积金
	// 子女教育专项扣除	住房贷款利息专项扣除	住房租金专项扣除	继续教育专项扣除	赡养老人专项扣除	婴幼儿照护费 累计个人养老金
	// 减除费用	表单上传人
	@ExcelProperty("是否劳务费")
	private String formType;
	@ExcelProperty("手机号码")
	private String empPhone;
	@ExcelProperty("计税月份")
	private String taxMonth;
	@ExcelProperty("结算月份")
	private String settlementMonth;
	@ExcelProperty("工资月份")
	private String salaryMonth;
	@ExcelProperty("出账单位")
	private String invoiceTitle;
	@ExcelProperty("业务类型分类")
	private String businessPrimaryType;
	@ExcelProperty("业务类型二级分类")
	private String businessSecondType;
	@ExcelProperty("业务类型三级分类")
	private String businessThirdType;
	@ExcelProperty("结算单位")
	private String unitName;
	@ExcelProperty("结算单位编码")
	private String unitNo;
	@ExcelProperty("结算部门")
	private String deptName;
	@ExcelProperty("部门编码")
	private String deptNo;
	@ExcelProperty("员工姓名")
	private String empName;
	@ExcelProperty("身份证号")
	private String empIdcard;
	@ExcelProperty("工资应发")
	private BigDecimal relaySalary;
	@ExcelProperty("个人实发合计")
	private BigDecimal actualSalary;
	@ExcelProperty("年终奖")
	private BigDecimal annualBonus;
	@ExcelProperty("薪资个税")
	private BigDecimal salaryTax;
	@ExcelProperty(value = "年终奖扣税")
	private BigDecimal annualBonusTax;
	@ExcelProperty("个人社保")
	private BigDecimal personSocial;
	@ExcelProperty("个人公积金")
	private BigDecimal personFund;
	@ExcelProperty("免个税个人代扣")
	private BigDecimal exemptionPersionTax;
	@ExcelProperty("企业（职业）年金")
	private BigDecimal enterpriseAnnuity;
	@ExcelProperty("单位社保")
	private BigDecimal unitSocial;
	@ExcelProperty("单位公积金")
	private BigDecimal unitFund;
	// 子女教育专项扣除	住房贷款利息专项扣除	住房租金专项扣除	继续教育专项扣除	赡养老人专项扣除	婴幼儿照护费 累计个人养老金
	@ExcelProperty(value = "子女教育专项扣除")
	private BigDecimal sumChildEduMoney;
	@ExcelProperty(value = "住房贷款利息专项扣除")
	private BigDecimal sumHousingLoanMoney;
	@ExcelProperty(value = "住房租金专项扣除")
	private BigDecimal sumHousingRentMoney;
	@ExcelProperty(value = "继续教育专项扣除")
	private BigDecimal sumContinuingEducationMoney;
	@ExcelProperty(value = "赡养老人专项扣除")
	private BigDecimal sumSupportElderlyMoney;
	@ExcelProperty(value = "累计个人养老金")
	private BigDecimal sumPrivatePension;
	@ExcelProperty(value = "婴幼儿照护费")
	private BigDecimal sumBabyMoney;
	@ExcelProperty("减除费用")
	private BigDecimal costReduction;
	@ExcelProperty("通讯补贴（不计税）")
	private BigDecimal phoneSubsidy;

	@ExcelProperty("车改补贴（不计税）")
	private BigDecimal carNotTax;
	@ExcelProperty("表单上传人")
	private String createName;

	@ExcelProperty("个人代扣明细")
	private String pdeductionDetail;
	@ExcelProperty("个人代扣金额")
	private String pdeductionMoney;
	/**
	 * 支出信息结算状态 0 已结算 1 结算中 2 未结算
	 */
	@ExcelProperty("支出结算状态")
	private String paySettleFlag;

	@ExcelProperty("薪酬状态")
	private String status;
	//新增薪酬申请编号 fxj v1.7.10  2025-04-25
	@ExcelProperty("薪酬申请单号")
	private String applyNo;


}
